/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.BooleanOption;
import com.uppaal.engine.Choice;
import com.uppaal.engine.ChoiceOption;
import com.uppaal.engine.DecimalOption;
import com.uppaal.engine.EngineException;
import com.uppaal.engine.GenericOptionVisitor;
import com.uppaal.engine.IntegerOption;
import com.uppaal.engine.Option;
import com.uppaal.engine.OptionSet;
import com.uppaal.engine.OptionVisitor;
import com.uppaal.engine.ValueOption;
import com.uppaal.model.core2.EngineSettings;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EngineOptions {
    private static final ResourceBundle LOCALE = ResourceBundle.getBundle("locale.Options");
    private final ArrayList<Option<?>> options = new ArrayList();
    private final Map<String, Option<?>> index = new HashMap();

    private static String localize(String text) {
        return LOCALE.containsKey(text) ? LOCALE.getString(text) : text;
    }

    public void parse(String engineOptionsInfo) throws EngineException {
        assert (engineOptionsInfo != null);
        this.index.clear();
        this.options.clear();
        try {
            InputSource source = new InputSource(new StringReader(engineOptionsInfo));
            Document optionsDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
            NodeIterator i = ((DocumentTraversal)((Object)optionsDoc)).createNodeIterator(optionsDoc.getDocumentElement(), 1, null, false);
            Node node = i.nextNode();
            block12: while (node != null) {
                if (node.getNodeName().equals("option")) {
                    Element element = (Element)node;
                    String name = element.getAttribute("name");
                    assert (name != null);
                    String type = element.getAttribute("type");
                    if (type == null) {
                        throw new EngineException("Error: engine option '" + name + "' has no 'type' attribute");
                    }
                    switch (type) {
                        case "choice": {
                            ArrayList<Choice> choices = new ArrayList<Choice>();
                            String display = EngineOptions.localize(element.getAttribute("display"));
                            String defaultValue = element.getAttribute("default");
                            String value = element.getAttribute("value");
                            node = i.nextNode();
                            while (node != null && node.getNodeName().equals("choice")) {
                                element = (Element)node;
                                choices.add(new Choice(element.getAttribute("name"), EngineOptions.localize(element.getAttribute("display"))));
                                node = i.nextNode();
                            }
                            ChoiceOption option = new ChoiceOption(name, display, choices, defaultValue, value);
                            this.options.add(option);
                            this.index.put(option.getName(), option);
                            continue block12;
                        }
                        case "boolean": {
                            BooleanOption option = new BooleanOption(name, EngineOptions.localize(element.getAttribute("display")), element.getAttribute("default"), element.getAttribute("value"));
                            this.options.add(option);
                            this.index.put(option.getName(), option);
                            node = i.nextNode();
                            continue block12;
                        }
                        case "parameterset": {
                            OptionSet parameterSet = new OptionSet(name, EngineOptions.localize(element.getAttribute("display")));
                            node = i.nextNode();
                            while (node != null && "parameter".equals(node.getNodeName())) {
                                ValueOption parameter;
                                element = (Element)node;
                                name = element.getAttribute("name");
                                assert (name != null);
                                type = element.getAttribute("type");
                                if ("integer".equals(type)) {
                                    parameter = new IntegerOption(name, EngineOptions.localize(element.getAttribute("display")), element.getAttribute("default"), element.getAttribute("value"), element.getAttribute("rangemin"), element.getAttribute("rangemax"));
                                    parameterSet.add(parameter);
                                    this.index.put(parameter.getName(), parameter);
                                    node = i.nextNode();
                                    continue;
                                }
                                if ("decimal".equals(type)) {
                                    parameter = new DecimalOption(name, EngineOptions.localize(element.getAttribute("display")), element.getAttribute("default"), element.getAttribute("value"), element.getAttribute("rangemin"), element.getAttribute("rangemax"), element.getAttribute("fracmin"), element.getAttribute("fracmax"));
                                    parameterSet.add(parameter);
                                    this.index.put(parameter.getName(), parameter);
                                    node = i.nextNode();
                                    continue;
                                }
                                if ("choice".equals(type)) {
                                    ArrayList<Choice> choices = new ArrayList<Choice>();
                                    String display = EngineOptions.localize(element.getAttribute("display"));
                                    String defaultValue = element.getAttribute("default");
                                    String value = element.getAttribute("value");
                                    node = i.nextNode();
                                    while (node != null && node.getNodeName().equals("choice")) {
                                        element = (Element)node;
                                        choices.add(new Choice(element.getAttribute("name"), EngineOptions.localize(element.getAttribute("display"))));
                                        node = i.nextNode();
                                    }
                                    ChoiceOption parameter2 = new ChoiceOption(name, display, choices, defaultValue, value);
                                    parameterSet.add(parameter2);
                                    this.index.put(parameter2.getName(), parameter2);
                                    continue;
                                }
                                throw new EngineException("Error: unrecognized parameter type '" + type + "' for parameter '" + name + "'");
                            }
                            this.options.add(parameterSet);
                            continue block12;
                        }
                    }
                    throw new EngineException("Error: unrecognized option type '" + type + "'");
                }
                if (!node.getNodeName().equals("server")) {
                    throw new EngineException("Error: unrecognized tag '" + node.getNodeName() + "' in engine options");
                }
                node = i.nextNode();
            }
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new EngineException("Engine option parsing error: " + ex.getMessage());
        }
    }

    public void reset() {
        this.index.clear();
        this.options.clear();
    }

    public void validate(EngineSettings settings, List<String> unsupportedOptions) {
        if (settings == null) {
            throw new IllegalArgumentException("Settings cannot be null");
        }
        if (unsupportedOptions == null) {
            throw new IllegalArgumentException("Unsupported option list cannot be null");
        }
        ArrayList<String> bad = new ArrayList<String>();
        com.uppaal.model.core2.Element prototype = settings.getPrototype();
        if (prototype == null) {
            settings.setPrototype(this.getDefaultSettings());
        }
        settings.getProperties().forEach((name, prop) -> {
            Option<?> opt = this.index.get(name);
            if (opt == null) {
                unsupportedOptions.add((String)name);
                bad.add((String)name);
            } else {
                try {
                    opt.fromString((String)prop.getValue());
                }
                catch (Exception ignored) {
                    unsupportedOptions.add((String)name);
                }
            }
        });
        if (!bad.isEmpty()) {
            settings.resetToDefault(bad);
        }
    }

    public String getText(final EngineSettings settings) {
        final StringBuilder sb = new StringBuilder();
        this.accept(new GenericOptionVisitor(){

            @Override
            public <T> void handleOption(Option<T> opt) {
                T value = settings.getValue(opt);
                if (value != null) {
                    sb.append(opt.name).append(' ').append(value).append(' ');
                }
            }
        });
        return sb.toString();
    }

    public EngineSettings getDefaultSettings() {
        final EngineSettings settings = new EngineSettings(null);
        this.accept(new GenericOptionVisitor(){

            @Override
            public <T> void handleOption(Option<T> option) {
                settings.setValue(option, option.getDefaultValue());
            }
        });
        return settings;
    }

    public void accept(OptionVisitor visitor) {
        for (Option<?> o : this.options) {
            o.accept(visitor);
        }
    }
}

