/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.Choice;
import com.uppaal.engine.OptionVisitor;
import com.uppaal.engine.ValueOption;
import java.util.List;

public class ChoiceOption
extends ValueOption<Choice> {
    protected final List<Choice> choices;

    public ChoiceOption(String name, String display, List<Choice> choices, String defaultValue, String value) {
        super(name, display, ChoiceOption.findIn(defaultValue, choices), ChoiceOption.findIn(value, choices));
        this.choices = choices;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    @Override
    public void accept(OptionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Choice fromString(String value) {
        return ChoiceOption.findIn(value, this.choices);
    }

    private static Choice findIn(String value, List<Choice> choices) {
        for (Choice choice : choices) {
            if (!choice.getValue().equals(value)) continue;
            return choice;
        }
        return null;
    }
}

