/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.uppaal.engine.BinaryResolution;
import com.uppaal.engine.connection.BundledConnection;
import com.uppaal.engine.protocol.LicenseMissingException;
import com.uppaal.gui.MainOptions;
import com.uppaal.gui.OSLCOptions;
import com.uppaal.gui.ViewOptions;
import com.uppaal.language.LanguageServer;
import com.uppaal.model.OSUtils;
import com.uppaal.model.Translator;
import com.uppaal.model.core2.AbstractTemplate;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.DocumentPrototype;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.lsc.LscTemplate;
import com.uppaal.model.io2.CachedOutputStream;
import com.uppaal.model.system.EmptyTranslator;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Taskbar;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.IconUIResource;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import org.freehep.graphicsbase.util.UserProperties;
import org.swixml.SwingEngine;

public class Main {
    public static final boolean EXTRA_FEATURES = System.getProperty("uppaal.extra") != null;
    public static final boolean YGGDRASIL_FEATURES = System.getProperty("uppaal.yggdrasil") != null;
    public static final boolean LSC = System.getProperty("uppaal.lsc") != null;
    public static final String DEFAULT_NEW_SYSTEM = "com/uppaal/resource/default.xml";
    public static final String DEFAULT_OPTIONS = "com/uppaal/resource/options.xml";
    public static DocumentPrototype protoDoc;
    public static float defaultEditorZoom;
    public static float defaultSimulatorZoom;
    public static BinaryResolution binaryResolution;
    public static String DOCUMENTATION_URL;
    public static String exportTemplate;
    public static String exportFile;
    public static String exportXTAFile;
    public static lL warningDialog;
    public static lG choiceDialog;
    public static lL errorDialog;
    public static lL fatalErrorDialog;
    public static lL queryResultDialog;
    private static as frame;
    public static boolean antialias;
    public static ResourceBundle LOCALE;
    public static final String ENCAPSULATED = "Uppaal.Encapsulated";
    public static Locale[] supportedLocales;
    public static MainOptions mainOptions;
    public static ViewOptions editorOptions;
    public static ViewOptions displayOptions;
    public static OSLCOptions oslcRequirementOptions;
    public static OSLCOptions oslcModelOptions;
    public static OSLCOptions oslcSuiteOptions;
    public static OSLCOptions oslcUploadOptions;
    public static final bn[] themes;

    public static boolean isDarkTheme() {
        if (mainOptions == null) {
            return false;
        }
        return Main.mainOptions.themeName.equals("FLATLAF_DARK");
    }

    public static void main(String[] stringArray) {
        Object object = System.getProperty("java.version");
        if (object != null && !((String)object).isBlank()) {
            try {
                int n2 = ((String)object).indexOf(46);
                if ((n2 < 0 ? Integer.parseInt((String)object) : Integer.parseInt(((String)object).substring(0, n2))) < 11) {
                    System.err.println(MessageFormat.format("UPPAAL requires JAVA virtual machine {0} or higher.", 11));
                    System.exit(1);
                }
            }
            catch (Exception exception) {
                System.err.println("JRE version check failed: " + exception.getLocalizedMessage());
            }
        }
        Main.loadDefaultAndSavedOption();
        File file = Main.getInstallDirectory();
        Main.configureLanguageServer();
        object = Main.processCommandLine(stringArray);
        Main.handleCommandLineSwitches((URI)object);
        if (GraphicsEnvironment.isHeadless()) {
            System.out.println(LOCALE.getString("m_gui_headlessModeNotSupported"));
            return;
        }
        Main.setupDefaultExceptionHandler();
        Main.setupSwingLookAndFeel(file);
        SwingUtilities.invokeLater(() -> Main.lambda$main$0((URI)object));
    }

    private static void configureLanguageServer() {
        LanguageServer.setBinaryResolutionStrategy((BinaryResolution)binaryResolution);
        if (!Main.mainOptions.enabledAutocomplete) {
            LanguageServer.disable();
        }
    }

    private static void loadDefaultAndSavedOption() {
        mainOptions = new MainOptions();
        if (Main.mainOptions.language != null && !Main.mainOptions.language.isEmpty()) {
            Locale locale = new Locale(Main.mainOptions.language);
            Locale.setDefault(locale);
            SwingEngine.setDefaultLocale(locale);
            LOCALE = ResourceBundle.getBundle("locale.Main");
        }
        editorOptions = new ViewOptions("editor");
        displayOptions = new ViewOptions("display");
        oslcRequirementOptions = new OSLCOptions("oslcRequirements");
        oslcModelOptions = new OSLCOptions("oslcModels");
        oslcSuiteOptions = new OSLCOptions("oslcSuite");
        oslcUploadOptions = new OSLCOptions("oslcUpload");
    }

    public static void setupPlatformIntegration() {
        try {
            Object object;
            Object object2;
            if (Taskbar.isTaskbarSupported() && ((Taskbar)(object2 = Taskbar.getTaskbar())).isSupported(Taskbar.Feature.ICON_IMAGE) && (object = ClassLoader.getSystemResource("com/uppaal/resource/images/icon-64x64.png")) != null) {
                object = new ImageIcon((URL)object).getImage();
                ((Taskbar)object2).setIconImage((Image)object);
            }
            if (Desktop.isDesktopSupported()) {
                object2 = Desktop.getDesktop();
                if (((Desktop)object2).isSupported(Desktop.Action.APP_PREFERENCES)) {
                    ((Desktop)object2).setPreferencesHandler(preferencesEvent -> frame.d());
                }
                if (((Desktop)object2).isSupported(Desktop.Action.APP_ABOUT)) {
                    ((Desktop)object2).setAboutHandler(aboutEvent -> frame.e());
                }
                if (((Desktop)object2).isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
                    ((Desktop)object2).setQuitHandler((quitEvent, quitResponse) -> {
                        frame.f();
                        quitResponse.cancelQuit();
                    });
                }
                if (((Desktop)object2).isSupported(Desktop.Action.APP_OPEN_FILE)) {
                    ((Desktop)object2).setOpenFileHandler(openFilesEvent -> {
                        if (openFilesEvent.getFiles().isEmpty()) {
                            return;
                        }
                        if (frame.a()) {
                            frame.a(openFilesEvent.getFiles().get(0));
                        }
                    });
                }
                if (((Desktop)object2).isSupported(Desktop.Action.APP_OPEN_URI)) {
                    ((Desktop)object2).setOpenURIHandler(openURIEvent -> {
                        try {
                            if (frame.a()) {
                                frame.a(openURIEvent.getURI(), false);
                            }
                            return;
                        }
                        catch (IOException iOException) {
                            System.err.println("Failed to open " + openURIEvent.getURI());
                            return;
                        }
                    });
                }
            }
            return;
        }
        catch (SecurityException | UnsupportedOperationException runtimeException) {
            System.err.println("Desktop integration: " + runtimeException.getMessage());
            return;
        }
    }

    public static void setupSwingLookAndFeel(File object) {
        SwingUtilities.invokeLater(() -> ToolTipManager.sharedInstance().setDismissDelay(100000));
        SwingUtilities.invokeLater(() -> Main.setupPlatformIntegration());
        Main.loadFonts(new File((File)object, "fonts"));
        if ((double)Math.abs(Main.mainOptions.fontScale - 1.0f) > 0.001) {
            o.a(Main.mainOptions.fontScale);
        }
        Main.replaceSwingIcons();
        object = mainOptions.a();
        bo.a((bn)object);
        SwingUtilities.invokeLater(() -> Main.lambda$setupSwingLookAndFeel$8((bn)object));
        SwingUtilities.invokeLater(() -> {
            try {
                UIManager.getDefaults().addResourceBundle("locale.Swing");
                return;
            }
            catch (Exception exception) {
                System.err.println("While setting Swing locale: " + exception);
                return;
            }
        });
    }

    private static void setupDefaultExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
            try {
                throwable.printStackTrace();
                if (!(throwable instanceof HeadlessException) && !(throwable instanceof NoClassDefFoundError)) {
                    SwingUtilities.invokeLater(() -> {
                        if (fatalErrorDialog != null) {
                            fatalErrorDialog.b(throwable);
                            return;
                        }
                        System.exit(1);
                    });
                    return;
                }
                System.exit(1);
                return;
            }
            catch (Exception exception) {
                System.err.println("Exception inside exception handler: ");
                throwable.printStackTrace();
                System.exit(1);
                return;
            }
        });
    }

    public static void openBrowser(String string) {
        try {
            Desktop desktop = Desktop.getDesktop();
            URI uRI = new URI(string);
            if (Desktop.isDesktopSupported() && desktop.isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(uRI);
                return;
            }
            switch (OSUtils.getOS()) {
                case LINUX: {
                    Object object = System.getenv("XDG_CURRENT_DESKTOP");
                    if (object != null && !((String)object).isBlank()) {
                        object = Runtime.getRuntime().exec(new String[]{"xdg-open", string});
                        ((Process)object).waitFor();
                        if (((Process)object).exitValue() != 0) {
                            desktop.browse(uRI);
                        }
                        return;
                    }
                    if (Runtime.getRuntime().exec(new String[]{"sensible-browser", string}).exitValue() != 0) {
                        desktop.browse(uRI);
                    }
                    return;
                }
                case MACOS: {
                    Process process = Runtime.getRuntime().exec(new String[]{"open", string});
                    process.waitFor();
                    if (process.exitValue() == 0) break;
                    desktop.browse(uRI);
                    return;
                }
                case WIN: {
                    Process process = Runtime.getRuntime().exec(new String[]{"start", string});
                    process.waitFor();
                    if (process.exitValue() == 0) break;
                    desktop.browse(uRI);
                    return;
                }
                default: {
                    desktop.browse(uRI);
                }
            }
            return;
        }
        catch (Exception exception) {
            String string2 = MessageFormat.format(LOCALE.getString("m_browserfailed"), string);
            JOptionPane.showMessageDialog(null, string2, "Failed to open Browser", 1);
            return;
        }
    }

    private static void handleCommandLineSwitches(URI uRI) {
        if (antialias) {
            System.setProperty("awt.useSystemAAFontSettings", "on");
            System.setProperty("swing.aatext", "true");
        }
        if (Main.mainOptions.language != null && !Main.mainOptions.language.isEmpty()) {
            Locale.setDefault(new Locale(Main.mainOptions.language));
        }
        if (exportTemplate != null) {
            if (uRI == null) {
                System.err.println(LOCALE.getString("m_provideSpecError"));
                System.exit(1);
            }
            if (exportFile == null) {
                System.err.println(LOCALE.getString("m_provideExportFilename"));
                System.exit(1);
            }
            try {
                bo.a(mainOptions.a());
                if (protoDoc == null) {
                    protoDoc = new p();
                }
                Document document = protoDoc.load(uRI);
                if ("system".equals(exportTemplate)) {
                    File file = new File(exportFile).getAbsoluteFile();
                    String string = file.getParent();
                    int n2 = file.getName().indexOf(46);
                    String string2 = n2 < 0 ? ".eps" : exportFile.substring(n2);
                    for (AbstractTemplate abstractTemplate : document.getTemplateList()) {
                        String string3 = (String)abstractTemplate.getPropertyValue("name");
                        Main.export(abstractTemplate, new File(string, string3 + string2).getPath());
                    }
                } else {
                    AbstractTemplate abstractTemplate = document.findTemplate(exportTemplate);
                    if (abstractTemplate == null) {
                        System.err.println(MessageFormat.format(LOCALE.getString("m_templateNotFoundError"), exportTemplate));
                        System.exit(1);
                    }
                    Main.export(abstractTemplate, exportFile);
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                exception.printStackTrace(System.err);
                System.exit(1);
            }
            System.exit(0);
        }
        if (exportXTAFile != null) {
            if (uRI == null) {
                System.err.println(LOCALE.getString("m_provideSpecError"));
                System.exit(1);
            }
            try {
                if (protoDoc == null) {
                    protoDoc = new p();
                }
                protoDoc.load(uRI).save(exportXTAFile);
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                exception.printStackTrace(System.err);
                System.exit(1);
            }
            System.exit(0);
        }
    }

    private static void replaceSwingIcons() {
        String[] stringArray = new String[]{"FileView.fileIcon", "FileView.directoryIcon", "FileChooser.homeFolderIcon", "FileChooser.upFolderIcon", "FileChooser.newFolderIcon", "Tree.leafIcon", "Tree.closedIcon", "Tree.openIcon", "OptionPane.errorIcon", "OptionPane.informationIcon", "OptionPane.questionIcon", "OptionPane.warningIcon"};
        String[] stringArray2 = new String[]{"document.svg", "folder.svg", "folder-home.svg", "folder-up.svg", "folder-new.svg", "document.svg", "folder.svg", "folder-open.svg", "dialog-error.svg", "dialog-information.svg", "dialog-question.svg", "dialog-warning.svg"};
        SwingUtilities.invokeLater(() -> {
            UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Icon icon = uIDefaults.getIcon(stringArray[i2]);
                if (icon == null) continue;
                ImageIcon imageIcon = lE.a(stringArray2[i2], Math.round((float)icon.getIconWidth() * Main.mainOptions.fontScale), Math.round((float)icon.getIconHeight() * Main.mainOptions.fontScale));
                icon = icon instanceof IconUIResource ? new IconUIResource(imageIcon) : imageIcon;
                UIManager.put(stringArray[i2], icon);
            }
        });
    }

    private static void loadFonts(File list) {
        try {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            List.of();
            list = ((File)((Object)list)).exists() ? Files.find(Paths.get(((File)((Object)list)).getAbsolutePath(), new String[0]), Integer.MAX_VALUE, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && path.getFileName().toString().toUpperCase().endsWith(".TTF"), new FileVisitOption[0]).collect(Collectors.toList()) : Files.find(Paths.get(new File(System.getProperty("user.dir"), "fonts").getAbsolutePath(), new String[0]), Integer.MAX_VALUE, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && path.getFileName().toString().toUpperCase().endsWith(".TTF"), new FileVisitOption[0]).collect(Collectors.toList());
            list.forEach(path -> {
                try {
                    Font font = Font.createFont(0, path.toFile());
                    graphicsEnvironment.registerFont(font);
                    return;
                }
                catch (FontFormatException | IOException exception) {
                    System.out.println("Error loading font " + path.getFileName());
                    return;
                }
            });
        }
        catch (IOException iOException) {}
        SwingUtilities.invokeLater(() -> {
            Font font = UIManager.getFont("TextField.font");
            if (font != null) {
                font = new Font(Main.mainOptions.font_family, 0, font.getSize());
                Map<TextAttribute, ?> map = font.getAttributes();
                map.put(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON);
                font = font.deriveFont(map);
                UIManager.put("TextField.font", font);
                DocumentPrototype.FONT = font.deriveFont(14.0f);
            }
        });
    }

    private static void initialize(URI uRI) {
        Serializable serializable;
        frame = new as();
        if ((double)Math.abs(Main.mainOptions.fontScale - 1.0f) > 0.001) {
            serializable = frame.getSize();
            ((Dimension)serializable).height = (int)((float)((Dimension)serializable).height * Main.mainOptions.fontScale);
            ((Dimension)serializable).width = (int)((float)((Dimension)serializable).width * Main.mainOptions.fontScale);
            frame.setSize((Dimension)serializable);
        }
        choiceDialog = new lG(frame, LOCALE.getString("m_choose"));
        warningDialog = new lL(frame, LOCALE.getString("m_warning"), 2);
        errorDialog = new lL(frame, LOCALE.getString("m_error"), 0);
        fatalErrorDialog = new lL(frame, LOCALE.getString("m_internalError"), 0);
        queryResultDialog = new lL(frame, LOCALE.getString("m_queryResult"), 1);
        try {
            if (uRI != null) {
                if ("file".equals(uRI.getScheme())) {
                    serializable = new File(uRI);
                    frame.b((File)serializable);
                    Main.setCurrentDir(((File)serializable).getAbsoluteFile().getParentFile());
                } else {
                    frame.a(uRI, false);
                }
            } else {
                frame.g();
            }
        }
        catch (Exception exception) {
            frame.g();
            SwingUtilities.invokeLater(() -> errorDialog.b(exception));
        }
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
        Main.checkVersion(frame);
    }

    private static void checkVersion(as as2) {
        new bz((String)"5.1.0-beta4").a.copy().thenAccept(optional -> {
            boolean bl2;
            if (!optional.isPresent()) return;
            bB bB2 = (bB)optional.get();
            if (bB2.a == null) return;
            int n2 = bB2.a.compareTo(bB.a());
            if (n2 > 0) {
                bl2 = true;
            } else {
                if (n2 != 0) return;
                if (bB2.a == null) return;
                if (bB2.a.equals("5.1.0-beta4")) return;
                if (bB2.a.equals(Main.mainOptions.latestKnownVersion)) return;
                bl2 = true;
            }
            if (!bl2) return;
            Main.displayNewerNewVersionDialog(as2, (bB)optional.get());
        }).swingExceptionally(errorDialog::b);
    }

    private static void displayNewerNewVersionDialog(as as2, bB bB2) {
        int n2;
        Object object = ResourceBundle.getBundle("locale.Main");
        object = bB2.a + " " + ((ResourceBundle)object).getString("vd_is_now_available");
        JEditorPane jEditorPane = Main.createHTMLMessage(as2, bB2.b);
        int n3 = n2 = Math.round(64.0f * Main.mainOptions.fontScale);
        ImageIcon imageIcon = lE.a("uppaal.svg", n3, n3);
        if (JOptionPane.showConfirmDialog(as2, jEditorPane, (String)object, -1, 1, imageIcon) == 0) {
            Main.mainOptions.latestKnownVersion = bB2.a;
            Main.mainOptions.latestReleaseNotifiedDate = bB2.a;
        }
    }

    public static JEditorPane createHTMLMessage(as as2, String object) {
        object = new JEditorPane("text/html", (String)object);
        ((JTextComponent)object).setEditable(false);
        ((JComponent)object).setBackground(as2.getBackground());
        ((HTMLDocument)((JTextComponent)object).getDocument()).getStyleSheet().addRule("body{font-family:verdana,helvetica,arial,sans-serif;}");
        ((JEditorPane)object).addHyperlinkListener(new ac((JEditorPane)object));
        return object;
    }

    private static BinaryResolution createBinaryResolution() {
        try {
            String string = Main.class.getName().replace(".", "/") + ".class";
            Main.class.getClassLoader();
            String string2 = ClassLoader.getSystemResource(string).toURI().toString();
            int n2 = string2.lastIndexOf("uppaal.jar!/" + string);
            if (n2 < 0) {
                n2 = string2.lastIndexOf("/" + string);
            }
            string2 = string2.substring(0, n2);
            return new BinaryResolution(new File(new URI(string2)));
        }
        catch (Exception exception) {
            Object object = System.getProperty("java.class.path");
            for (String string : ((String)object).split(File.pathSeparator)) {
                if (!string.endsWith("uppaal.jar")) continue;
                object = new File(string).getParentFile();
                if (object == null) {
                    object = new File(".");
                }
                return new BinaryResolution((File)object);
            }
            for (String string : ((String)object).split(File.pathSeparator)) {
                if (!string.endsWith(".jar") || !"lib".equals(((File)(object = new File(string).getAbsoluteFile().getParentFile())).getName())) continue;
                if ((object = ((File)object).getParentFile()) == null) {
                    object = new File(".");
                }
                return new BinaryResolution((File)object);
            }
            return new BinaryResolution(new File("."));
        }
    }

    public static File getInstallDirectory() {
        return binaryResolution.getInstallDirectory();
    }

    private static URI processCommandLine(String[] stringArray) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] == null || stringArray[n2].length() == 0) {
                ++n2;
                continue;
            }
            if (stringArray[n2].charAt(0) != '-') break;
            n2 += Main.handleOption(stringArray, n2) + 1;
        }
        if (n2 + 1 < stringArray.length) {
            System.err.println(MessageFormat.format(LOCALE.getString("m_invalidArgument"), stringArray[n2 + 1]));
            Main.usage();
        }
        if (n2 < stringArray.length) {
            try {
                return new URL(stringArray[n2]).toURI();
            }
            catch (MalformedURLException | URISyntaxException exception) {
                try {
                    return new File(stringArray[n2]).toURI();
                }
                catch (Exception exception2) {
                    System.err.println(exception2.getMessage());
                    System.exit(1);
                }
            }
        }
        return null;
    }

    private static void usage() {
        System.out.println(LOCALE.getString("m_usage"));
    }

    private static void invalidOption(String string) {
        System.err.println(string);
        Main.usage();
        System.exit(1);
    }

    private static int handleOption(String[] stringArray, int n2) {
        if ("--antialias".equals(stringArray[n2])) {
            antialias = true;
            return 0;
        }
        if ("--no-antialias".equals(stringArray[n2])) {
            antialias = false;
            return 0;
        }
        if ("--export".equals(stringArray[n2])) {
            if (stringArray.length >= ++n2 + 1 && stringArray[n2] != null && stringArray[n2].length() > 0) {
                exportTemplate = stringArray[n2];
                if (stringArray[++n2] != null && stringArray[n2].length() > 0) {
                    exportFile = stringArray[n2];
                    return 2;
                }
            }
            System.out.println(LOCALE.getString("m_handleOption_illegalValueExport"));
        } else if ("--export-xta".equals(stringArray[n2])) {
            if (stringArray.length >= ++n2 && stringArray[n2] != null && stringArray[n2].length() > 0) {
                exportXTAFile = stringArray[n2];
                return 1;
            }
        } else if ("--enginePath".equals(stringArray[n2])) {
            if (stringArray.length <= ++n2) {
                throw new RuntimeException("No server path provided");
            }
            BundledConnection.setBundledEngine((File)new File(stringArray[n2]));
        } else if ("--theme".equals(stringArray[n2])) {
            int n3;
            if (stringArray.length <= ++n2) {
                System.err.println("Missing a theme name argument. Supported themes:");
                bn[] bnArray = themes;
                int n4 = themes.length;
                for (int i2 = 0; i2 < n4; ++i2) {
                    bn bn2 = bnArray[i2];
                    System.err.println("\t" + bn2.a);
                }
                throw new RuntimeException("No theme name provided");
            }
            boolean bl2 = false;
            bn[] bnArray = themes;
            int n5 = themes.length;
            for (n3 = 0; n3 < n5; ++n3) {
                if (!bnArray[n3].a.equals(stringArray[n2])) continue;
                bl2 = true;
            }
            if (!bl2) {
                System.err.println("Unknown theme \"" + stringArray[n2] + "\". Supported themes names:");
                bnArray = themes;
                n5 = themes.length;
                for (n3 = 0; n3 < n5; ++n3) {
                    bn bn3 = bnArray[n3];
                    System.err.println("\t" + bn3.a);
                }
                throw new RuntimeException("Unsupported theme name: " + stringArray[n2]);
            }
            Main.mainOptions.themeName = stringArray[n2];
        } else if ("--help".equals(stringArray[n2])) {
            Main.usage();
            System.exit(0);
        } else {
            Main.invalidOption(MessageFormat.format(LOCALE.getString("m_handleOption_unknownOption"), stringArray[n2]));
        }
        return 1;
    }

    public static String getResourceString(String string) {
        return LOCALE.getString(string);
    }

    public static void showMessageDialog(JFrame jFrame, String string, int n2) {
        assert (SwingUtilities.isEventDispatchThread());
        JOptionPane.showMessageDialog(jFrame, Main.getResourceString(string + ".Message"), Main.getResourceString(string + ".Title"), n2);
    }

    public static String getShortVersion() {
        return "UPPAAL 5.1.0-beta4";
    }

    public static String getVersion() {
        return "(Academic) UPPAAL 5.1.0-beta4 (rev. EB64CC30D74BA740), 2023-11-20";
    }

    public static String getLongVersion() {
        return "UPPAAL 5.1.0-beta4 (rev. EB64CC30D74BA740), 2023-11-20";
    }

    public static boolean isPreviewBuild() {
        return false;
    }

    protected static void export(AbstractTemplate abstractTemplate, String string) {
        boolean bl2;
        CachedOutputStream cachedOutputStream = new CachedOutputStream(new File(string));
        EmptyTranslator emptyTranslator = new EmptyTranslator();
        UserProperties userProperties = lt.a();
        lt.a((Properties)userProperties, (String)abstractTemplate.getPropertyValue("name"));
        userProperties.setProperty(ENCAPSULATED, true);
        lw lw2 = new lw();
        String string2 = string;
        lw lw3 = lw2;
        string2 = new File(string2).getName();
        int n2 = string2.lastIndexOf(46);
        if (n2 < 0) {
            bl2 = false;
        } else {
            String string3 = string2.substring(n2 + 1).toLowerCase();
            if (!lw3.a(string3)) {
                int n3 = string2.lastIndexOf(46, n2 - 1);
                if (n3 < 0) {
                    bl2 = false;
                } else {
                    string3 = string2.substring(n3 + 1, string2.length()).toLowerCase();
                    if (!lw3.a(string3)) {
                        string3 = string2.substring(n3 + 1, n2).toLowerCase();
                        bl2 = lw3.a(string3);
                    } else {
                        bl2 = true;
                    }
                }
            } else {
                bl2 = true;
            }
        }
        if (!bl2) {
            System.err.println(MessageFormat.format(LOCALE.getString("m_handleOption_formatNotSupported"), string));
            System.exit(1);
        }
        if (abstractTemplate instanceof LscTemplate) {
            de.a((LscTemplate)abstractTemplate, (OutputStream)cachedOutputStream, lw2, userProperties, 1.0);
        } else {
            cx.a((Template)abstractTemplate, (OutputStream)cachedOutputStream, lw2, userProperties, editorOptions, (Translator)emptyTranslator, 1.0);
        }
        cachedOutputStream.close();
    }

    public static File getCurrentDir() {
        return Main.mainOptions.currentDir;
    }

    public static void setCurrentDir(File file) {
        Main.mainOptions.currentDir = file;
    }

    public static File getExportDir() {
        return Main.mainOptions.exportDir;
    }

    public static void setExportDir(File file) {
        Main.mainOptions.exportDir = file;
    }

    public static File getImportDir() {
        return Main.mainOptions.importDir;
    }

    public static void setImportDir(File file) {
        Main.mainOptions.importDir = file;
    }

    public static void saveOptions() {
        mainOptions.b();
        editorOptions.b();
        displayOptions.b();
        oslcRequirementOptions.b();
        oslcModelOptions.b();
        oslcSuiteOptions.b();
        oslcUploadOptions.b();
    }

    public static String getSystemDescription() {
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Java version: ").append(System.getProperty("java.version")).append(string).append("Java vendor: ").append(System.getProperty("java.vendor")).append(string).append("JVM version: ").append(System.getProperty("java.vm.version")).append("\nJVM vendor: ").append(System.getProperty("java.vm.vendor")).append("\nJVM name: ").append(System.getProperty("java.vm.name")).append(string).append("JRE version: ").append(System.getProperty("java.specification.version")).append(string).append("JRE vendor: ").append(System.getProperty("java.specification.vendor")).append(string).append("JRE name: ").append(System.getProperty("java.specification.name")).append("\nOS name: ").append(System.getProperty("os.name")).append(string).append("OS arch: ").append(System.getProperty("os.arch")).append(string).append("OS version: ").append(System.getProperty("os.version"));
        return stringBuilder.toString();
    }

    public static void showNonLicenseException(Throwable throwable) {
        if (throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        if (!(throwable instanceof LicenseMissingException)) {
            errorDialog.b(throwable);
        }
    }

    private static /* synthetic */ void lambda$setupSwingLookAndFeel$8(bn bn2) {
        try {
            if (bn2.a.booleanValue()) {
                FlatDarkLaf.registerCustomDefaultsSource((String)"com.uppaal.resource.colors");
                FlatDarkLaf.setup();
            } else {
                UIManager.setLookAndFeel(bn2.b);
            }
            bo.a(bn2);
            return;
        }
        catch (Exception exception) {
            System.out.println("Warning: failed setting the Look and Feel");
            return;
        }
    }

    private static /* synthetic */ void lambda$main$0(URI uRI) {
        Main.initialize(uRI);
    }

    static {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = System.out;
        System.setOut(new PrintStream(new lC()));
        SwingEngine.isMacOSX();
        System.setOut((PrintStream)lookAndFeelInfoArray);
        if (SwingEngine.isMacOSX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.application.name", "UPPAAL");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "UPPAAL");
        }
        protoDoc = null;
        defaultEditorZoom = 1.0f;
        defaultSimulatorZoom = 0.75f;
        binaryResolution = Main.createBinaryResolution();
        DOCUMENTATION_URL = "https://docs.uppaal.org";
        exportTemplate = null;
        exportFile = null;
        exportXTAFile = null;
        antialias = true;
        LOCALE = ResourceBundle.getBundle("locale.Main");
        supportedLocales = new Locale[]{Locale.getDefault(), new Locale("en"), new Locale("da"), new Locale("fr"), new Locale("ja"), new Locale("zh"), new Locale("ru"), new Locale("lt")};
        lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        themes = new bn[lookAndFeelInfoArray.length + 4];
        int n2 = 0;
        ++n2;
        Boolean bl2 = Boolean.FALSE;
        Main.themes[0] = new bn("NATIVE", LOCALE.getString("m_theme_NATIVE"), UIManager.getSystemLookAndFeelClassName(), bl2, bl2);
        ++n2;
        Boolean bl3 = Boolean.FALSE;
        Main.themes[1] = new bn("JAVA", LOCALE.getString("m_theme_JAVA"), UIManager.getCrossPlatformLookAndFeelClassName(), bl3, bl3);
        ++n2;
        Main.themes[2] = new bn("FLATLAF", LOCALE.getString("m_theme_FLATLAF"), FlatLightLaf.class.getName(), Boolean.FALSE, Boolean.TRUE);
        ++n2;
        Boolean bl4 = Boolean.TRUE;
        Main.themes[3] = new bn("FLATLAF_DARK", LOCALE.getString("m_theme_FLATLAF_DARK"), FlatDarkLaf.class.getName(), bl4, bl4);
        for (int i2 = 0; i2 < lookAndFeelInfoArray.length; ++i2) {
            int n3 = n2++;
            Boolean bl5 = Boolean.FALSE;
            Main.themes[n3] = new bn(lookAndFeelInfoArray[i2].getName(), lookAndFeelInfoArray[i2].getName(), lookAndFeelInfoArray[i2].getClassName(), bl5, bl5);
        }
    }
}

