/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2.lsc;

import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.EventListener;
import com.uppaal.model.core2.Visitor;
import com.uppaal.model.core2.lsc.AnchoredElement;
import com.uppaal.model.core2.lsc.InstanceLine;
import java.util.ArrayList;
import java.util.Iterator;

public class Condition
extends AnchoredElement {
    ArrayList<InstanceLine> anchors = new ArrayList();

    public Condition(Element prototype) {
        super(prototype);
    }

    @Override
    public InstanceLine getAnchor() {
        if (this.anchors.size() > 0) {
            return this.anchors.get(0);
        }
        return null;
    }

    @Override
    public void setAnchor(InstanceLine anchor) {
        InstanceLine old = this.getAnchor();
        if (this.anchors.size() == 0) {
            this.anchors.add(anchor);
        } else {
            this.anchors.set(0, anchor);
        }
        this.fireAnchorChanged(old);
    }

    @Override
    public void accept(Visitor visitor) throws Exception {
        visitor.visitCondition(this);
    }

    @Override
    public Element getPrototypeFromParent(Element parent) {
        return (Element)parent.getPropertyValue("#condition");
    }

    public int getWidth() {
        int min;
        InstanceLine anchor0 = this.anchors.size() == 0 ? null : this.anchors.get(0);
        int max = min = anchor0 == null ? this.getX() : anchor0.getX();
        for (InstanceLine anchor : this.anchors) {
            int x;
            int n = x = anchor == null ? this.getX() : anchor.getX();
            if (x > max) {
                max = x;
            }
            if (x >= min) continue;
            min = x;
        }
        return Math.max(max - min + 20, this.getWidth(null));
    }

    @Override
    protected void fireAnchorChanged(InstanceLine oldAnchor) {
        if (this.getDocument() != null) {
            Element element = this;
            do {
                if (element.listeners == null) continue;
                for (EventListener l : element.listeners) {
                    l.anchorChanged(this, oldAnchor, this.getAnchor());
                }
            } while ((element = element.prototype) != null);
        }
    }

    @Override
    public ArrayList<InstanceLine> getAnchors() {
        return this.anchors;
    }

    public void addAnchor(InstanceLine anchor) {
        if (this.anchors.contains(anchor)) {
            return;
        }
        if (anchor != null) {
            int d = 0;
            ArrayList<Integer> array = new ArrayList<Integer>();
            for (int i = 0; i < this.anchors.size(); ++i) {
                if (this.anchors.get(i) != null) continue;
                array.add(i + d);
                --d;
            }
            Iterator i$ = array.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                this.anchors.remove(i);
            }
        }
        this.anchors.add(anchor);
    }

    public void removeAnchor(InstanceLine anchor) {
        this.anchors.remove(anchor);
    }

    @Override
    public boolean isHot() {
        return (Boolean)this.getPropertyValue("hot");
    }

    public void setAnchors(ArrayList<InstanceLine> anchors) {
        this.anchors = anchors;
    }

    @Override
    public Element getLabel() {
        return this.getProperty("condition");
    }

    @Override
    public String getLabelValue() {
        return (String)this.getPropertyValue("condition");
    }
}

