/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractCommand;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.lsc.Condition;
import com.uppaal.model.core2.lsc.InstanceLine;
import com.uppaal.model.core2.lsc.Prechart;
import com.uppaal.model.core2.lsc.Update;
import com.uppaal.model.core2.lsc.ViewWorkAround;
import java.util.ArrayList;

public class RemoveElementCommand
extends AbstractCommand {
    protected Node node;
    protected Node parent;
    private ViewWorkAround view;
    private Prechart prechart;
    private ArrayList<Condition> conditions;
    private Update update = null;

    public RemoveElementCommand(Node node) {
        this.node = node;
    }

    public RemoveElementCommand(Node node, ViewWorkAround view) {
        this.node = node;
        this.view = view;
        this.prechart = view.getPrechart();
        this.conditions = view.getConditionsOf(node);
        if (node instanceof Condition) {
            this.update = view.getUpdateOf(node);
        }
    }

    @Override
    public void execute() {
        if (this.prechart != null) {
            this.addAnchoredElements(false);
        }
        if (this.conditions != null && this.conditions.size() > 0) {
            this.addAnchoredToCondition(false);
        }
        if (this.update != null) {
            this.update.remove();
        }
        this.parent = (Node)this.node.getParent();
        this.node.remove();
    }

    private void addAnchoredElements(boolean b) {
        if (!(this.node instanceof InstanceLine)) {
            return;
        }
        if (b) {
            this.prechart.add((InstanceLine)this.node);
        } else {
            this.prechart.remove((InstanceLine)this.node);
        }
        this.view.populatePrechart(this.node.getTemplate());
    }

    private void addAnchoredToCondition(boolean b) {
        for (Condition condition : this.conditions) {
            if (b) {
                condition.addAnchor((InstanceLine)this.node);
                continue;
            }
            condition.removeAnchor((InstanceLine)this.node);
        }
        this.view.populateCondition(this.node.getTemplate());
    }

    @Override
    public void undo() {
        this.parent.insert(this.node, this.node.previous);
        if (this.prechart != null) {
            this.addAnchoredElements(true);
        }
        if (this.conditions != null && this.conditions.size() > 0) {
            this.addAnchoredToCondition(true);
        }
        if (this.update != null) {
            this.parent.insert(this.update, this.update.previous);
        }
    }

    @Override
    public Element getModifiedElement() {
        if (this.node.getParent() == null) {
            return this.parent;
        }
        return this.node;
    }
}

