/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class PluginInfo {
    private String name;
    private String author;
    private String version;
    private String mainClass;
    private String title;
    private String description;
    private Map files;
    private Map properties;
    private boolean loadAtStart;

    public PluginInfo(Element node) {
        Element info = node.getChild("information");
        this.name = info.getChildTextNormalize("name");
        this.author = info.getChildTextNormalize("author");
        this.version = info.getChildTextNormalize("version");
        this.loadAtStart = info.getChild("load-at-start") != null;
        this.mainClass = node.getChild("plugin-desc").getAttributeValue("class");
        List desc = info.getChildren("description");
        Iterator i = desc.iterator();
        while (i.hasNext()) {
            Element d = (Element)i.next();
            String type = d.getAttributeValue("type");
            String text = d.getTextNormalize();
            if (type != null && type.equals("short")) {
                this.title = text;
                continue;
            }
            this.description = text;
        }
        Element resources = node.getChild("resources");
        if (resources != null) {
            List fileList = resources.getChildren("file");
            if (!fileList.isEmpty()) {
                this.files = new HashMap();
            }
            Iterator i2 = fileList.iterator();
            while (i2.hasNext()) {
                Element f = (Element)i2.next();
                String href = f.getAttributeValue("href");
                String location = f.getAttributeValue("location");
                this.files.put(location, href);
            }
            List propList = resources.getChildren("property");
            if (!propList.isEmpty()) {
                this.properties = new HashMap();
            }
            Iterator i3 = propList.iterator();
            while (i3.hasNext()) {
                Element f = (Element)i3.next();
                String name = f.getAttributeValue("name");
                String value = f.getAttributeValue("value");
                this.properties.put(name, value);
            }
        }
    }

    public boolean equals(Object o) {
        if (o instanceof PluginInfo) {
            return this.name.equals(((PluginInfo)o).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    String getMainClass() {
        return this.mainClass;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    boolean loadAtStart() {
        return this.loadAtStart;
    }

    public Map getFiles() {
        return this.files == null ? Collections.EMPTY_MAP : this.files;
    }

    public Map getProperties() {
        return this.properties == null ? Collections.EMPTY_MAP : this.properties;
    }
}

