/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2.lsc;

import com.uppaal.model.core2.AbstractTransaction;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.lsc.Condition;
import com.uppaal.model.core2.lsc.InstanceLine;
import com.uppaal.model.core2.lsc.Update;
import com.uppaal.model.core2.lsc.ViewWorkAround;

public class RemoveAnchorCommand
extends AbstractTransaction {
    protected InstanceLine oldAnchor;
    protected Condition element;
    private ViewWorkAround view;
    private Update update;

    public RemoveAnchorCommand(Document document, Element element, InstanceLine anchor) {
        super(document);
        this.element = (Condition)element;
        this.oldAnchor = anchor;
    }

    public void removeAnchor(ViewWorkAround view) {
        this.view = view;
        this.element.getAnchors().remove(this.oldAnchor);
        for (InstanceLine anchor : this.element.getAnchors()) {
            anchor.setProperty("x", anchor.getX());
        }
        Update newUpdate = view.getAnchoredToConditionUpdate(this.element, this.oldAnchor);
        if (newUpdate != null) {
            this.update = null;
        }
    }

    @Override
    protected void doCancel() {
        this.doUndo();
    }

    @Override
    protected void doExecute() {
        this.removeAnchor(this.view);
        for (InstanceLine anchor : this.element.getAnchors()) {
            anchor.setProperty("x", anchor.getX());
        }
    }

    @Override
    protected void doUndo() {
        this.element.addAnchor(this.oldAnchor);
        for (InstanceLine anchor : this.element.getAnchors()) {
            anchor.setProperty("x", anchor.getX());
        }
        if (this.update != null) {
            ((Node)this.element.getParent()).insert(this.update, this.update.previous);
        }
    }

    @Override
    public Element getModifiedElement() {
        return this.element;
    }
}

