/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model;

import com.uppaal.model.AbstractSystemLocation;
import com.uppaal.model.system.Polyhedron;
import java.util.Arrays;

public abstract class AbstractSystemState {
    private int[] variables;
    private Polyhedron zone;

    public AbstractSystemState(int[] v, Polyhedron z) {
        this.variables = v;
        this.zone = z;
    }

    public String toServerFormat() {
        AbstractSystemLocation[] locations;
        StringBuffer s = new StringBuffer();
        for (AbstractSystemLocation location : locations = this.getLocationVector()) {
            s.append(String.valueOf(location.getIndex()));
            s.append('\n');
        }
        s.append(".\n");
        s.append(this.zone.writeTextualFormat());
        for (int i : this.variables) {
            s.append(i).append('\n');
        }
        s.append('.');
        return s.toString();
    }

    public String toXTRFormat() {
        return this.toServerFormat() + "\n";
    }

    public String traceFormat() {
        AbstractSystemLocation[] locations;
        StringBuffer s = new StringBuffer("(");
        boolean first = true;
        for (AbstractSystemLocation location : locations = this.getLocationVector()) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            String name = location.getName();
            s.append(name == null || name.length() == 0 ? "-" : name);
        }
        s.append(")");
        return s.toString();
    }

    public Polyhedron getPolyhedron() {
        return this.zone;
    }

    public int[] getVariables() {
        return this.variables;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        AbstractSystemState s = (AbstractSystemState)obj;
        return Arrays.equals(this.getLocationVector(), s.getLocationVector()) && Arrays.equals(this.variables, s.variables) && this.zone.equals(s.zone);
    }

    public abstract AbstractSystemLocation[] getLocationVector();
}

