/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.EngineException;
import com.uppaal.engine.LexicalAnalyser;
import com.uppaal.engine.Problem;
import com.uppaal.engine.ProtocolException;
import com.uppaal.engine.ServerException;
import com.uppaal.model.core2.Document;
import com.uppaal.model.lscsystem.LscProcess;
import com.uppaal.model.system.IdentifierTranslator;
import com.uppaal.model.system.Polyhedron;
import com.uppaal.model.system.SystemEdge;
import com.uppaal.model.system.SystemLocation;
import com.uppaal.model.system.SystemState;
import com.uppaal.model.system.Transition;
import com.uppaal.model.system.UppaalSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Vector;

public class Parser
extends LexicalAnalyser {
    private static ResourceBundle locale = ResourceBundle.getBundle("locale.Parser");

    public Parser(InputStream in) {
        super(in);
    }

    public void parseProlog() throws EngineException, IOException {
        String response = this.parseId();
        if (response.equals("error")) {
            throw new ServerException(this.readBlock());
        }
        if (!response.equals("ok")) {
            throw new ProtocolException("Bug: Ok expected");
        }
    }

    public String parseId() throws ProtocolException, IOException {
        if (this.nextToken() != 2) {
            throw new ProtocolException("Bug: Word expected");
        }
        return this.getWord();
    }

    public int parseInteger() throws ProtocolException, IOException, ServerException {
        int token = this.nextToken();
        if (token != 4) {
            if (token == 2 && this.getWord().equals("error")) {
                throw new ServerException(this.readBlock());
            }
            throw new ProtocolException("Bug: Integer expected");
        }
        return this.getValue();
    }

    public void parseEnd() throws ProtocolException, IOException {
        int token = this.nextToken();
        if (token != 1) {
            throw new ProtocolException("Bug: Dot expected");
        }
    }

    public SystemState parseState(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        SystemLocation[] l = this.locationVector(system);
        Polyhedron z = this.zone(system);
        int[] v = this.variableVector(system);
        return new SystemState(l, v, z);
    }

    private SystemLocation[] locationVector(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        SystemLocation[] locations = new SystemLocation[system.getNoOfProcesses()];
        int i = 0;
        do {
            locations[i] = system.getLocation(i, this.parseInteger());
            ++i;
        } while (this.getLookahead() != 1);
        this.parseEnd();
        return locations;
    }

    private int[] variableVector(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        int[] vector = new int[system.getNoOfVariables()];
        int i = 0;
        while (this.getLookahead() != 1) {
            vector[i++] = this.parseInteger();
        }
        this.parseEnd();
        return vector;
    }

    private Polyhedron zone(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        Polyhedron pol = new Polyhedron(system);
        while (this.getLookahead() != 1) {
            int i = this.parseInteger();
            int j = this.parseInteger();
            int b = this.parseInteger();
            pol.add(i, j, b ^ 1);
            this.parseEnd();
        }
        this.parseEnd();
        pol.trim();
        return pol;
    }

    public SystemEdge[] parseEdges(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        this.parseInteger();
        LinkedList<SystemEdge> l = new LinkedList<SystemEdge>();
        while (this.getLookahead() != 1) {
            l.add(this.edge(system));
        }
        this.parseEnd();
        return l.toArray(new SystemEdge[0]);
    }

    private SystemEdge edge(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        int i = this.parseInteger();
        int j = this.parseInteger();
        return system.getEdge(i, j - 1);
    }

    public Vector<Transition> parseEnabledTransitions(UppaalSystem system) throws EngineException, IOException {
        Vector<Transition> succs = new Vector<Transition>();
        this.parseProlog();
        block6: while (this.getLookahead() != 1) {
            switch (this.parseInteger()) {
                case 0: {
                    SystemState src = this.parseState(system);
                    SystemEdge[] e = this.parseEdges(system);
                    SystemState dst = this.parseState(system);
                    succs.add(new Transition(src, e, dst));
                    continue block6;
                }
                case 1: {
                    SystemState src = this.parseState(system);
                    succs.add(new Transition(src, new SystemEdge[0], null));
                    continue block6;
                }
                case 2: {
                    SystemState src = this.parseState(system);
                    SystemEdge[] e = this.parseEdges(system);
                    succs.add(new Transition(src, e, null));
                    continue block6;
                }
                case 3: {
                    this.parseEnd();
                    return null;
                }
            }
            throw new ProtocolException("Bug: Unknown transition type");
        }
        this.parseEnd();
        return succs;
    }

    public void parseAcknowledgement() throws EngineException, IOException {
        this.parseProlog();
        this.parseEnd();
    }

    public String parseBlock() throws EngineException, IOException {
        this.parseProlog();
        return this.readBlock();
    }

    public SystemState parseInitial(UppaalSystem system) throws EngineException, IOException {
        this.parseProlog();
        return this.parseState(system);
    }

    public UppaalSystem parseSystem(Document document) throws EngineException, IOException {
        Vector<String> vars = this.ids();
        Vector<String> clocks = this.ids();
        UppaalSystem system = new UppaalSystem(document);
        system.setVariables(vars);
        system.setClocks(clocks);
        this.processes(system);
        return system;
    }

    public LscProcess parseLscProcess(Document document) throws EngineException, IOException {
        return null;
    }

    private Vector<String> ids() throws EngineException, IOException {
        Vector<String> ids = new Vector<String>();
        while (this.getLookahead() != 1) {
            ids.add(this.parseId());
        }
        this.parseEnd();
        return ids;
    }

    private void processes(UppaalSystem system) throws EngineException, IOException {
        while (this.getLookahead() != 1) {
            String processName = this.parseId();
            String templateName = this.parseId();
            HashMap<String, String> map = new HashMap<String, String>();
            while (this.getLookahead() != 1) {
                String parameter = this.parseId();
                String argument = this.readBlock();
                map.put(parameter, argument);
            }
            this.parseEnd();
            while (this.getLookahead() != 1) {
                this.parseInteger();
            }
            this.parseEnd();
            system.addProcess(processName, templateName, new IdentifierTranslator(map));
        }
        this.parseEnd();
    }

    private void lscProcess(UppaalSystem system) throws EngineException, IOException {
        if (this.getLookahead() != 1) {
            // empty if block
        }
        this.parseEnd();
    }

    public Vector<Problem> parseProblems() throws EngineException, IOException {
        Vector<Problem> problems = new Vector<Problem>();
        this.parseProblems(problems);
        return problems;
    }

    public void parseProblems(Vector<Problem> problems) throws EngineException, IOException {
        this.parseProlog();
        while (this.getLookahead() != 1) {
            problems.add(this.problem());
        }
        this.parseEnd();
    }

    public boolean skipProblems() throws EngineException, IOException {
        this.parseProlog();
        if (this.getLookahead() == 1) {
            this.parseEnd();
            return false;
        }
        do {
            this.problem();
        } while (this.getLookahead() != 1);
        this.parseEnd();
        return true;
    }

    private Problem problem() throws EngineException, IOException {
        String type = this.parseId();
        String path = this.readBlock();
        int fline = this.parseInteger();
        int fcolumn = this.parseInteger();
        int lline = this.parseInteger();
        int lcolumn = this.parseInteger();
        String msg = this.readBlock();
        return new Problem(type, path, fline, fcolumn, lline, lcolumn, msg);
    }

    public char parseQueryResult() throws EngineException, IOException {
        this.parseProlog();
        return this.parseId().charAt(0);
    }

    public Vector<Transition> parseXTRTrace(UppaalSystem system) throws ProtocolException, IOException {
        Vector<Transition> trace = new Vector<Transition>();
        try {
            SystemState src = this.parseState(system);
            trace.add(new Transition(null, null, src));
            while (this.getLookahead() != 1) {
                SystemState dst = this.parseState(system);
                SystemEdge[] edges = this.edgesXTR(system);
                trace.add(new Transition(src, edges, dst));
                src = dst;
            }
            this.parseEnd();
        }
        catch (ProtocolException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ProtocolException(locale.getString("trace_mismatch"));
        }
        return trace;
    }

    private SystemEdge[] edgesXTR(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        Vector<SystemEdge> edges = new Vector<SystemEdge>();
        do {
            edges.add(this.edge(system));
        } while (this.getLookahead() != 1);
        this.parseEnd();
        Object[] array = new SystemEdge[edges.size()];
        edges.copyInto(array);
        return array;
    }
}

