/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2.lsc;

import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.TranslationCommand;
import com.uppaal.model.core2.lsc.LscConstants;
import com.uppaal.model.core2.lsc.LscTemplate;
import com.uppaal.model.core2.lsc.Message;
import java.util.Vector;

public class TranslationMessageLabelCommand
extends TranslationCommand
implements LscConstants {
    private float initialPos;
    private float newPos;
    int y1;

    public TranslationMessageLabelCommand(Document document, Vector<Element> elements) {
        super(document, elements);
        Property label = (Property)this.getModifiedElement();
        Message message = (Message)label.getParent();
        Float f = (Float)label.getPropertyValue("f");
        if (f.floatValue() == 10.0f) {
            int s = message.getSource() == null ? message.getX() : message.getSource().getX();
            int t = message.getTarget() == null ? message.getX() : message.getTarget().getX();
            f = Float.valueOf(((float)label.getX() - (float)s) / (float)(t - s));
        }
        this.initialPos = f.floatValue();
        label.setProperty("f", Float.valueOf(10.0f));
    }

    @Override
    protected void moveElements(int x, int y) {
        int length;
        int ye = this.getY() + y;
        if (ye >= (length = ((LscTemplate)this.getModifiedElement().getTemplate()).getLength() + 10) || ye <= 0) {
            y = 0;
        }
        for (Element element : this.elements) {
            element.setProperty("x", element.getX() + x);
            element.setProperty("y", element.getY() + y);
        }
        this.y1 = y;
    }

    private int getY() {
        return ((Element)this.elements.get(0)).getY() + ((Element)this.elements.get(0)).getParent().getY();
    }

    @Override
    public void move(int x, int y) {
        assert (!this.committed) : "Cannot move a committed translation";
        this.moveElements(x, y);
        this.xd += x;
        this.yd += this.y1;
    }

    @Override
    protected void doCancel() {
        this.moveElements(-this.xd, -this.yd);
        this.getModifiedElement().setProperty("f", Float.valueOf(this.initialPos));
        this.yd = 0;
        this.xd = 0;
        this.newPos = 0.0f;
        this.initialPos = 0.0f;
    }

    @Override
    protected void doExecute() {
        this.moveElements(this.xd, this.yd);
        this.getModifiedElement().setProperty("f", Float.valueOf(this.newPos));
    }

    @Override
    protected void doUndo() {
        this.moveElements(-this.xd, -this.yd);
        this.getModifiedElement().setProperty("f", Float.valueOf(this.initialPos));
    }

    public void updateF() {
        Message message;
        Element label = null;
        for (Element e : this.elements) {
            if (!(e instanceof Property)) continue;
            label = (Property)e;
            break;
        }
        int s = (message = (Message)label.getParent()).getSource() == null ? message.getX() : message.getSource().getX();
        int t = message.getTarget() == null ? message.getX() : message.getTarget().getX();
        int x = (Integer)label.getPropertyValue("x");
        this.newPos = ((float)x - (float)s) / (float)(t - s);
        label.setProperty("f", Float.valueOf(this.newPos));
    }
}

