/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.AbstractProcess;
import com.uppaal.model.Translator;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Template;
import com.uppaal.model.system.SystemEdge;
import com.uppaal.model.system.SystemLocation;
import java.util.Vector;

public class Process
extends AbstractProcess {
    private Vector<SystemLocation> locations = new Vector();
    private Vector<SystemEdge> edges = new Vector();

    Process(String name, int index, Template template, Translator translator) {
        super(name, index, template, translator);
    }

    void addEdge(Edge edge) {
        String sync = (String)edge.getPropertyValue("synchronisation");
        if (sync != null && sync.length() > 0) {
            sync = this.translator.translate(sync);
        }
        this.edges.add(new SystemEdge(this, this.edges.size(), sync, edge));
    }

    void addLocation(Location location) {
        this.locations.add(new SystemLocation(this, this.locations.size(), location));
    }

    public SystemEdge getEdge(int edge) {
        return this.edges.get(edge);
    }

    public final Vector<SystemEdge> getEdges() {
        return this.edges;
    }

    public SystemLocation getLocation(int i) {
        return this.locations.get(i);
    }

    public Vector<SystemLocation> getLocations() {
        return this.locations;
    }
}

