/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system.symbolic;

import com.uppaal.model.system.Polyhedron;
import com.uppaal.model.system.SystemLocation;
import com.uppaal.model.system.SystemState;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

public class SymbolicState
extends SystemState {
    private final int[] varValues;
    private final Polyhedron zone;

    public SymbolicState(SystemLocation[] l, int[] v, Polyhedron z) {
        super(l);
        this.varValues = v;
        this.zone = z;
    }

    public void writeServerFormat(Writer writer) throws IOException {
        for (SystemLocation location : this.getLocations()) {
            writer.write(String.valueOf(location.getIndex()));
            writer.write(10);
        }
        writer.write(".\n");
        this.zone.writeTextualFormat(writer);
        for (int i : this.varValues) {
            writer.write(String.valueOf(i));
            writer.write(10);
        }
        writer.write(46);
    }

    public void writeXTRFormat(Writer writer) throws IOException {
        this.writeServerFormat(writer);
        writer.write(10);
    }

    @Deprecated
    public SystemLocation[] getLocationVector() {
        return this.locations;
    }

    public Polyhedron getPolyhedron() {
        return this.zone;
    }

    public int[] getVariableValues() {
        return this.varValues;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        SymbolicState s = (SymbolicState)obj;
        return Arrays.equals(this.locations, s.locations) && Arrays.equals(this.varValues, s.varValues) && this.zone.equals(s.zone);
    }
}

