/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.core2.Edge;
import com.uppaal.model.system.Process;
import java.io.IOException;
import java.io.Writer;

public class SystemEdge {
    private final Process process;
    private final int index;
    private final String name;
    private final Edge edge;

    public SystemEdge(Process process, int index, String name, Edge edge) {
        this.process = process;
        this.index = index;
        this.name = name;
        this.edge = edge;
    }

    public Process getProcess() {
        return this.process;
    }

    public String getProcessName() {
        return this.process.getName();
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getFormatedName() {
        return this.process.getName() + "." + this.index + (String)(this.name != null ? "." + this.name : "");
    }

    public Edge getEdge() {
        return this.edge;
    }

    public void writeXTRFormat(Writer writer) throws IOException {
        writer.write(String.valueOf(this.getProcess().getIndex()));
        writer.write(32);
        writer.write(String.valueOf(this.getIndex() + 1));
        writer.write(10);
    }
}

