/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractCommand;
import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Property;

public class RemoveTextCommand
extends AbstractCommand {
    protected final Property property;
    protected int position;
    protected int length;
    protected Object oldvalue;
    protected int oldlength;
    protected String newvalue;

    public RemoveTextCommand(Property property, int position, int length) {
        assert (position >= 0);
        assert (length > 0);
        this.property = property;
        this.position = position;
        this.length = length;
        this.oldvalue = null;
        this.oldlength = 0;
        this.newvalue = null;
    }

    @Override
    public void execute() {
        this.oldvalue = this.property.getValue();
        String value = (String)this.oldvalue;
        assert (value != null);
        this.oldlength = value.length();
        if (this.newvalue == null) {
            assert (this.position + this.length <= this.oldlength);
            this.newvalue = value.substring(0, this.position) + value.substring(this.position + this.length);
        }
        this.property.setValue(this.newvalue);
    }

    @Override
    public boolean merge(Command next) {
        if (!(next instanceof RemoveTextCommand)) {
            return false;
        }
        RemoveTextCommand cmd = (RemoveTextCommand)next;
        assert (cmd.position + cmd.length <= this.oldlength - this.length);
        if (cmd.position + cmd.length == this.position) {
            this.length += cmd.length;
            this.position = cmd.position;
            this.newvalue = null;
            return true;
        }
        if (cmd.position == this.position) {
            this.length += cmd.length;
            this.newvalue = null;
            return true;
        }
        return false;
    }

    @Override
    public void undo() {
        this.property.setValue(this.oldvalue);
    }

    @Override
    public Element getModifiedElement() {
        return this.property;
    }

    public int getBeginIndex() {
        return this.position;
    }

    public int getEndIndex() {
        return this.position + this.length;
    }
}

