/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.CommandManager;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Query;
import com.uppaal.model.core2.Visitor;
import java.util.Iterator;

public class QueryList
extends Node
implements Iterable<Query> {
    public QueryList(Element prototype) {
        super(prototype);
        this.setCommandManager(new CommandManager());
    }

    public QueryList() {
        super(null);
        this.setCommandManager(new CommandManager());
    }

    public boolean isEmpty() {
        return this.getFirst() == null;
    }

    public void addLast(Query query) {
        this.insert((Node)query, this.getLast());
    }

    public void removeAll() {
        for (Query query : this) {
            this.remove(query);
        }
    }

    public Query get(int index) {
        Query query = (Query)this.getFirst();
        for (int i = 0; i < index && (query = (Query)query.getNext()) != null; ++i) {
        }
        return query;
    }

    public void insert(Query q, int index) {
        Query old = this.get(index);
        if (old == null) {
            this.insert((Node)q, this.getLast());
        } else {
            this.insert((Node)q, old.getPrevious());
        }
    }

    public void remove(Query query) {
        int index = this.indexOf(query);
        query.remove();
    }

    public void remove(int index) {
        Query q = this.get(index);
        q.remove();
    }

    public int indexOf(Query query) {
        int i = 0;
        for (Query q : this) {
            if (q == query) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int size() {
        Node n = this.getFirst();
        int i = 0;
        while (n != null) {
            n = n.getNext();
            ++i;
        }
        return i;
    }

    @Override
    public Iterator<Query> iterator() {
        return new Iterator<Query>(){
            private Node next;
            {
                this.next = QueryList.this.getFirst();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Query next() {
                Node n = this.next;
                this.next = this.next.getNext();
                return (Query)n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    public int getVersion() {
        return this.getCommandManager().getVersion();
    }

    @Override
    public void accept(Visitor visitor) throws Exception {
        visitor.visitQueries(this);
    }

    public boolean isBlank() {
        if (this.getFirst() == null) {
            return true;
        }
        for (Query q : this) {
            if (q.getComment().trim().isEmpty() && q.getFormula().trim().isEmpty()) continue;
            return false;
        }
        return true;
    }
}

