/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractCommand;
import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Property;

public class InsertTextCommand
extends AbstractCommand {
    protected final Property property;
    protected String text;
    protected final int position;
    protected Object oldvalue;
    protected int oldlength;
    protected String newvalue;

    public InsertTextCommand(Property property, String text, int position) {
        assert (position >= 0);
        this.property = property;
        this.text = text;
        this.position = position;
        this.oldvalue = null;
        this.oldlength = 0;
        this.newvalue = null;
    }

    @Override
    public void execute() {
        this.oldvalue = this.property.getValue();
        String value = (String)this.oldvalue;
        if (value == null) {
            this.oldlength = 0;
            this.property.setValue(this.text);
        } else {
            if (this.newvalue == null) {
                this.oldlength = value.length();
                assert (this.position <= this.oldlength);
                this.newvalue = value.substring(0, this.position) + this.text + value.substring(this.position);
            }
            this.property.setValue(this.newvalue);
        }
    }

    @Override
    public boolean merge(Command next) {
        if (!(next instanceof InsertTextCommand)) {
            return false;
        }
        InsertTextCommand cmd = (InsertTextCommand)next;
        assert (cmd.position <= this.oldlength + this.text.length());
        if (cmd.position == this.position) {
            this.text = cmd.text + this.text;
            this.newvalue = null;
            return true;
        }
        if (cmd.position == this.position + this.text.length()) {
            this.text = this.text + cmd.text;
            this.newvalue = null;
            return true;
        }
        return false;
    }

    @Override
    public void undo() {
        this.property.setValue(this.oldvalue);
    }

    @Override
    public Element getModifiedElement() {
        return this.property;
    }

    public int getBeginIndex() {
        return this.position;
    }

    public int getEndIndex() {
        return this.position + this.text.length();
    }
}

