/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.CannotRedoException;
import com.uppaal.model.core2.CannotUndoException;
import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.CommandListener;
import com.uppaal.model.core2.CompoundCommand;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;

public class CommandManager {
    private final AtomicInteger counter = new AtomicInteger();
    private int version = this.counter.incrementAndGet();
    private final LinkedList<Command> undoList = new LinkedList();
    private final LinkedList<Command> redoList = new LinkedList();
    private final LinkedList<CommandListener> cmdListeners = new LinkedList();

    public CommandManager() {
    }

    public CommandManager(CommandManager orig) {
        this.version = orig.version;
    }

    public int getVersion() {
        return this.version;
    }

    public void execute(Command command) {
        command.setVersion(this.version);
        this.version = this.counter.incrementAndGet();
        this.redoList.clear();
        command.execute();
        if (this.undoList.isEmpty() || !this.undoList.getLast().merge(command)) {
            this.undoList.add(command);
        }
        for (CommandListener l : this.cmdListeners) {
            l.executed(this, command);
        }
    }

    public void execute(Command ... commands) {
        this.execute((Command)new CompoundCommand(commands));
    }

    public Command getLastCommand() {
        return this.undoList.isEmpty() ? null : this.undoList.getLast();
    }

    public void undo() throws CannotUndoException {
        if (this.undoList.isEmpty()) {
            throw new CannotUndoException();
        }
        Command command = this.undoList.removeLast();
        int oldVersion = this.version;
        this.version = command.getVersion();
        command.setVersion(oldVersion);
        command.undo();
        this.redoList.add(command);
        for (CommandListener l : this.cmdListeners) {
            l.undone(this, command);
        }
    }

    public boolean canUndo() {
        return !this.undoList.isEmpty();
    }

    public void redo() throws CannotRedoException {
        if (this.redoList.isEmpty()) {
            throw new CannotRedoException();
        }
        Command command = this.redoList.removeLast();
        int oldVersion = this.version;
        this.version = command.getVersion();
        command.setVersion(oldVersion);
        command.execute();
        this.undoList.add(command);
        for (CommandListener l : this.cmdListeners) {
            l.redone(this, command);
        }
    }

    public boolean canRedo() {
        return !this.redoList.isEmpty();
    }

    public void addCommandListener(CommandListener listener) {
        if (listener != null) {
            this.cmdListeners.add(listener);
        }
    }

    public void removeCommandListener(CommandListener listener) {
        if (listener != null) {
            this.cmdListeners.remove(listener);
        }
    }
}

