/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.CannotEvaluateException;
import com.uppaal.engine.EngineException;
import com.uppaal.engine.Parser;
import com.uppaal.engine.Problem;
import com.uppaal.engine.Protocol;
import com.uppaal.engine.ProtocolException;
import com.uppaal.engine.QueryFeedback;
import com.uppaal.engine.QueryResult;
import com.uppaal.engine.ServerException;
import com.uppaal.model.core2.DataSet2D;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Query;
import com.uppaal.model.io2.XMLWriter;
import com.uppaal.model.lscsystem.LscProcess;
import com.uppaal.model.system.GanttChart;
import com.uppaal.model.system.SystemEdge;
import com.uppaal.model.system.SystemEdgeSelect;
import com.uppaal.model.system.SystemLocation;
import com.uppaal.model.system.UppaalSystem;
import com.uppaal.model.system.concrete.ConcreteState;
import com.uppaal.model.system.concrete.ConcreteSuccessor;
import com.uppaal.model.system.concrete.ConcreteTrace;
import com.uppaal.model.system.concrete.ConcreteTransitionRecord;
import com.uppaal.model.system.concrete.ConcreteVariable;
import com.uppaal.model.system.symbolic.SymbolicState;
import com.uppaal.model.system.symbolic.SymbolicTrace;
import com.uppaal.model.system.symbolic.SymbolicTransition;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.regex.Pattern;

public class DotProtocol
implements Protocol {
    private BufferedWriter out;
    private final InputStream in;
    private Parser parser;

    public DotProtocol(InputStream in, OutputStream out) {
        this.in = in;
        this.parser = new Parser(this.in);
        try {
            this.out = new BufferedWriter(new OutputStreamWriter(out, "utf-8"));
        }
        catch (Exception e) {
            this.out = new BufferedWriter(new OutputStreamWriter(out));
        }
    }

    @Override
    public void close() throws IOException {
        this.write("quit");
        this.flush();
    }

    @Override
    public SymbolicState getSymbolicInitial(UppaalSystem system) throws EngineException, IOException, CannotEvaluateException {
        this.write("getInitialState");
        this.flush();
        return this.parser.parseSymbolicInitial(system);
    }

    @Override
    public ConcreteState getConcreteInitial(UppaalSystem system) throws EngineException, IOException, CannotEvaluateException {
        this.write("concreteGetInitial");
        this.flush();
        return this.parser.parseConcreteInitial(system);
    }

    @Override
    public ConcreteSuccessor getConcreteSuccessor(UppaalSystem system, ConcreteState state, SystemEdgeSelect[] edges, BigDecimal currentTime, BigDecimal delay) throws EngineException, IOException, CannotEvaluateException {
        this.write("concreteGetSuccessor");
        this.write(currentTime.add(delay));
        this.write(state, delay);
        this.write(edges);
        this.write(".");
        this.flush();
        return this.parser.parseConcreteSuccessor(system);
    }

    @Override
    public String getOptionsInfo() throws EngineException, IOException {
        this.write("getOptionsInfo");
        this.flush();
        return this.parser.parseBlock();
    }

    @Override
    public ArrayList<SymbolicTransition> getTransitions(UppaalSystem system, SymbolicState state) throws EngineException, IOException, CannotEvaluateException {
        this.write("getTransitions");
        this.write(state);
        this.flush();
        return this.parser.parseEnabledTransitions(system);
    }

    @Override
    public String getVersion() throws IOException, EngineException {
        this.write("version");
        this.flush();
        return this.parser.parseBlock();
    }

    @Override
    public String getLicensee() throws IOException, EngineException {
        this.write("licensee");
        this.flush();
        return this.parser.parseBlock();
    }

    @Override
    public String getLeaseRequest(String license_key, String duration) throws IOException, EngineException {
        this.write("leaseRequest");
        this.write(license_key);
        this.write(duration);
        this.flush();
        return this.parser.parseBlock();
    }

    @Override
    public String installLease(String lease) throws IOException, EngineException {
        this.write("leaseInstall");
        this.write(lease + "\n");
        this.flush();
        return this.parser.parseBlock();
    }

    @Override
    public QueryResult query(UppaalSystem system, Query query, QueryFeedback f) throws EngineException, IOException {
        this.write("getSystemInfo");
        this.flush();
        String response = this.parser.parseId();
        if (null != response) {
            switch (response) {
                case "ok": {
                    f.setProgressAvail(true);
                    long virtual = this.parser.parseLong();
                    long physical = this.parser.parseLong();
                    long swap = this.parser.parseLong();
                    f.setSystemInfo(virtual, physical, swap);
                    this.parser.parseEnd();
                    break;
                }
                case "error": {
                    this.parser.readBlock();
                    f.setProgressAvail(false);
                }
            }
        }
        this.write("modelCheck");
        this.write(query.getShortFormula());
        this.write(".");
        this.flush();
        return this.processQueryFeedback(system, f);
    }

    @Override
    public QueryResult query(UppaalSystem system, SymbolicState state, Query query, QueryFeedback f) throws EngineException, IOException, CannotEvaluateException {
        this.write("getSystemInfo");
        this.flush();
        String response = this.parser.parseId();
        if (null != response) {
            switch (response) {
                case "ok": {
                    f.setProgressAvail(true);
                    f.setSystemInfo(this.parser.parseLong(), this.parser.parseLong(), this.parser.parseLong());
                    this.parser.parseEnd();
                    break;
                }
                case "error": {
                    this.parser.readBlock();
                    f.setProgressAvail(false);
                }
            }
        }
        this.write("modelCheckFromState");
        this.write(state);
        this.write(query.getShortFormula());
        this.write(".");
        this.flush();
        return this.processQueryFeedback(system, f);
    }

    protected static String unquote(String s) {
        if (s == null || s.length() <= 2) {
            return null;
        }
        return s.substring(1, s.length() - 1);
    }

    protected String parseResults(String results, QueryResult result) {
        String feedback = null;
        DataSet2D dataset = null;
        if (results == null) {
            return null;
        }
        Scanner scan = new Scanner(results);
        Pattern ws = scan.delimiter();
        Pattern end = Pattern.compile("\\\\$", 8);
        Pattern quoted = Pattern.compile("'[^']*'");
        scan.useLocale(Locale.US);
        try {
            while (scan.hasNext()) {
                String type = scan.next();
                if (type.length() > 1 || type.length() < 1) {
                    return results.trim();
                }
                scan.skip(ws);
                switch (type.charAt(0)) {
                    case 'M': {
                        scan.useDelimiter(end);
                        feedback = scan.next();
                        break;
                    }
                    case 'R': {
                        scan.useDelimiter(end);
                        result.setMessage(scan.next());
                        break;
                    }
                    case 'P': {
                        String title = DotProtocol.unquote(scan.findInLine(quoted));
                        String xlabel = DotProtocol.unquote(scan.findInLine(quoted));
                        String ylabel = DotProtocol.unquote(scan.findInLine(quoted));
                        dataset = new DataSet2D(title, xlabel, ylabel);
                        result.getData().addData(dataset);
                        break;
                    }
                    case 'D': {
                        if (dataset == null) break;
                        String title = DotProtocol.unquote(scan.findInLine(quoted));
                        type = scan.next();
                        String color = scan.next();
                        dataset.addData(title, type, Color.decode(color));
                        int count = scan.nextInt();
                        for (int i = 0; i < count; ++i) {
                            dataset.addSample(scan.nextDouble(), scan.nextDouble());
                        }
                        break;
                    }
                    case 'C': {
                        if (dataset == null) break;
                        scan.useDelimiter(end);
                        dataset.addComment(scan.next());
                        break;
                    }
                    default: {
                        System.err.println("Unknown item [" + type + "] in feedback.");
                    }
                }
                scan.findWithinHorizon(end, 0);
                scan.useDelimiter(ws);
            }
        }
        catch (Exception e) {
            System.err.println(results);
            e.printStackTrace(System.err);
        }
        return feedback;
    }

    private QueryResult processQueryFeedback(UppaalSystem system, QueryFeedback f) throws EngineException, IOException {
        String response;
        while ("progress".equals(response = this.parser.parseId())) {
            f.setProgress(this.parser.parseInteger(), this.parser.parseLong(), this.parser.parseLong(), this.parser.parseLong(), this.parser.parseLong(), this.parser.parseLong(), this.parser.parseLong(), this.parser.parseLong(), this.parser.parseLong(), this.parser.parseLong());
            this.parser.parseEnd();
        }
        if ("error".equals(response)) {
            throw new ServerException("Server exception: " + this.parser.readBlock());
        }
        if (!"ok".equals(response)) {
            throw new ProtocolException("Ok expected");
        }
        char result = this.parser.parseId().charAt(0);
        QueryResult queryResult = new QueryResult(result);
        if (result == 'E') {
            String errorPath = this.parser.readBlock();
            int startLine = this.parser.parseInteger();
            int startColumn = this.parser.parseInteger();
            int endLine = this.parser.parseInteger();
            int endColumn = this.parser.parseInteger();
            String errorDescription = this.parser.readBlock();
            String errorLocation = this.parser.readBlock();
            errorLocation = this.parser.getErrorContext(errorLocation, startLine, endLine);
            queryResult.set(new CannotEvaluateException(startLine, endLine, errorLocation, errorDescription, errorPath, startColumn, endColumn));
        }
        String results = this.parser.readBlock();
        int isSMCTrace = this.parser.parseInteger();
        int length = this.parser.parseInteger();
        if (isSMCTrace == 0) {
            int cycle = this.parser.parseInteger();
            if (length >= 0) {
                f.setLength(length);
                SymbolicTrace trace = new SymbolicTrace();
                trace.cycle = cycle;
                SymbolicState src = this.parser.parseSymbolicState(system);
                trace.add(new SymbolicTransition(null, null, src, null));
                for (int current = 0; current < length; ++current) {
                    SystemEdgeSelect[] edges = this.parser.parseEdgesWS(system);
                    SymbolicState dst = this.parser.parseSymbolicState(system);
                    trace.add(new SymbolicTransition(src, edges, dst, null));
                    src = dst;
                    f.setCurrent(current);
                }
                f.setTrace(result, this.parseResults(results, queryResult), trace, queryResult);
                this.parser.parseEnd();
            } else {
                f.setFeedback(this.parseResults(results, queryResult));
            }
        } else if (length >= 0) {
            f.setLength(length);
            ConcreteTrace trace = new ConcreteTrace();
            this.parser.parseInteger();
            ConcreteState initState = this.parser.parseConcreteState(system);
            trace.add(new ConcreteTransitionRecord(BigDecimal.ZERO, null, initState));
            for (int current = 0; current < length; ++current) {
                BigDecimal delay = BigDecimal.ZERO;
                int typeOfEntry = this.parser.parseInteger();
                while (typeOfEntry != 1) {
                    if (typeOfEntry == 0) {
                        delay = delay.add(this.parser.parseBigDecimal());
                    } else if (typeOfEntry == 2) {
                        this.parser.parseConcreteState(system);
                    }
                    typeOfEntry = this.parser.parseInteger();
                }
                SystemEdgeSelect[] edges = this.parser.parseEdgesWS(system);
                this.parser.parseInteger();
                ConcreteState target = this.parser.parseConcreteState(system);
                trace.add(new ConcreteTransitionRecord(delay, edges, target));
                f.setCurrent(current);
            }
            block9: while (true) {
                switch (this.parser.parseInteger()) {
                    case 3: {
                        break block9;
                    }
                    case 0: {
                        this.parser.parseBigDecimal();
                        continue block9;
                    }
                    case 2: {
                        this.parser.parseConcreteState(system);
                        continue block9;
                    }
                    default: {
                        throw new IOException("The trace of the transition must be show in the GUI.");
                    }
                }
                break;
            }
            f.setTrace(result, this.parseResults(results, queryResult), trace, queryResult);
            this.parser.parseEnd();
        } else {
            f.setFeedback(this.parseResults(results, queryResult));
        }
        return queryResult;
    }

    @Override
    public void setOptions(String options) throws EngineException, IOException {
        this.write("setOptions");
        this.write(options);
        this.write(".");
        this.flush();
        this.parser.parseAcknowledgement();
    }

    @Override
    public UppaalSystem upload(Document document, ArrayList<Problem> problems) throws EngineException, IOException {
        try {
            this.write("newXMLSystem3");
            document.accept(new XMLWriter(this.out));
            this.write("\n");
            this.write(".");
            this.flush();
            this.parser.parseProblems(problems);
            if (this.parser.parseInteger() == 1) {
                return this.parser.parseSystem(document);
            }
            return null;
        }
        catch (EngineException | IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineException(e.toString());
        }
    }

    @Override
    public UppaalSystem upload(Document document) throws EngineException, IOException {
        try {
            this.write("newXMLSystem3");
            document.accept(new XMLWriter(this.out));
            this.write("\n");
            this.write(".");
            this.flush();
            this.parser.skipProblems();
            if (this.parser.parseInteger() == 1) {
                return this.parser.parseSystem(document);
            }
            return null;
        }
        catch (EngineException | IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineException(e.toString());
        }
    }

    protected void write(String s) throws IOException {
        this.out.write(s);
        this.out.write(10);
    }

    protected void write(Object o) throws IOException {
        this.out.write(o.toString());
        this.out.write(10);
    }

    private void write(SymbolicState state) throws IOException {
        state.writeServerFormat(this.out);
        this.out.write(10);
    }

    protected void write(BigDecimal value) throws IOException {
        this.out.write(value.toPlainString());
        this.out.write(10);
    }

    protected void write(ConcreteState state, BigDecimal delay) throws IOException {
        SystemLocation[] locations = state.getLocations();
        ConcreteVariable[] variables = state.getCVariables();
        this.write(locations.length);
        for (SystemLocation location : locations) {
            this.write(location.getIndex());
        }
        this.write(variables.length);
        for (ConcreteVariable variable : variables) {
            this.write(variable.getValue(delay));
        }
    }

    protected void write(SystemEdge[] edges) throws IOException {
        this.write(edges.length);
        for (SystemEdge edge : edges) {
            this.write(edge.getProcess().getIndex() + " " + edge.getIndex());
        }
    }

    protected void write(SystemEdgeSelect[] edges) throws IOException {
        this.write(edges.length);
        for (SystemEdgeSelect edge : edges) {
            this.write(edge.getProcess().getIndex() + " " + edge.getIndex());
            List<Integer> listvalues = edge.getSelectList();
            this.write(listvalues.size());
            for (Integer i : listvalues) {
                this.write(i + " ");
            }
        }
    }

    protected void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public LscProcess uploadLsc(Document document, ArrayList<Problem> problems) throws EngineException, IOException {
        return null;
    }

    @Override
    public synchronized GanttChart getGanttChart(UppaalSystem system, BigDecimal globalTime) throws EngineException, IOException {
        return this.parser.parseGanttChart(system, globalTime);
    }
}

