/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import org.syntax.jedit.JEditTextArea;
import org.syntax.jedit.TextUtilities;

public class EditActionMap
extends ActionMap {
    public static final String SMART_HOME_END_PROPERTY = "InputHandler.homeEnd";
    public static final Action BACKSPACE = new backspace();
    public static final Action BACKSPACE_WORD = new backspace_word();
    public static final Action DELETE = new delete();
    public static final Action DELETE_WORD = new delete_word();
    public static final Action END = new end(false);
    public static final Action DOCUMENT_END = new document_end(false);
    public static final Action SELECT_ALL = new select_all();
    public static final Action SELECT_END = new end(true);
    public static final Action SELECT_DOC_END = new document_end(true);
    public static final Action INSERT_BREAK = new insert_break();
    public static final Action INSERT_TAB = new insert_tab();
    public static final Action HOME = new home(false);
    public static final Action DOCUMENT_HOME = new document_home(false);
    public static final Action SELECT_HOME = new home(true);
    public static final Action SELECT_DOC_HOME = new document_home(true);
    public static final Action NEXT_CHAR = new next_char(false);
    public static final Action NEXT_LINE = new next_line(false);
    public static final Action NEXT_PAGE = new next_page(false);
    public static final Action NEXT_WORD = new next_word(false);
    public static final Action SELECT_NEXT_CHAR = new next_char(true);
    public static final Action SELECT_NEXT_LINE = new next_line(true);
    public static final Action SELECT_NEXT_PAGE = new next_page(true);
    public static final Action SELECT_NEXT_WORD = new next_word(true);
    public static final Action OVERWRITE = new overwrite();
    public static final Action PREV_CHAR = new prev_char(false);
    public static final Action PREV_LINE = new prev_line(false);
    public static final Action PREV_PAGE = new prev_page(false);
    public static final Action PREV_WORD = new prev_word(false);
    public static final Action SELECT_PREV_CHAR = new prev_char(true);
    public static final Action SELECT_PREV_LINE = new prev_line(true);
    public static final Action SELECT_PREV_PAGE = new prev_page(true);
    public static final Action SELECT_PREV_WORD = new prev_word(true);
    public static final Action TOGGLE_RECT = new toggle_rect();
    public static final Action CLIP_COPY = new clip_copy();
    public static final Action CLIP_PASTE = new clip_paste();
    public static final Action CLIP_CUT = new clip_cut();
    public static final Action INSERT_CHAR = new insert_char();

    EditActionMap() {
        this.put("backspace", BACKSPACE);
        this.put("backspace-word", BACKSPACE_WORD);
        this.put("delete", DELETE);
        this.put("delete-word", DELETE_WORD);
        this.put("end", END);
        this.put("select-all", SELECT_ALL);
        this.put("select-end", SELECT_END);
        this.put("document-end", DOCUMENT_END);
        this.put("select-doc-end", SELECT_DOC_END);
        this.put("insert-break", INSERT_BREAK);
        this.put("insert-tab", INSERT_TAB);
        this.put("home", HOME);
        this.put("select-home", SELECT_HOME);
        this.put("document-home", DOCUMENT_HOME);
        this.put("select-doc-home", SELECT_DOC_HOME);
        this.put("next-char", NEXT_CHAR);
        this.put("next-line", NEXT_LINE);
        this.put("next-page", NEXT_PAGE);
        this.put("next-word", NEXT_WORD);
        this.put("select-next-char", SELECT_NEXT_CHAR);
        this.put("select-next-line", SELECT_NEXT_LINE);
        this.put("select-next-page", SELECT_NEXT_PAGE);
        this.put("select-next-word", SELECT_NEXT_WORD);
        this.put("overwrite", OVERWRITE);
        this.put("prev-char", PREV_CHAR);
        this.put("prev-line", PREV_LINE);
        this.put("prev-page", PREV_PAGE);
        this.put("prev-word", PREV_WORD);
        this.put("select-prev-char", SELECT_PREV_CHAR);
        this.put("select-prev-line", SELECT_PREV_LINE);
        this.put("select-prev-page", SELECT_PREV_PAGE);
        this.put("select-prev-word", SELECT_PREV_WORD);
        this.put("toggle-rect", TOGGLE_RECT);
        this.put("insert-char", INSERT_CHAR);
        this.put("clipboard-copy", CLIP_COPY);
        this.put("clipboard-paste", CLIP_PASTE);
        this.put("clipboard-cut", CLIP_CUT);
    }

    public static JEditTextArea getTextArea(EventObject evt) {
        Object o;
        if (evt != null && (o = evt.getSource()) instanceof Component) {
            Component c = (Component)o;
            while (true) {
                if (c instanceof JEditTextArea) {
                    return (JEditTextArea)c;
                }
                if (c == null) break;
                if (c instanceof JPopupMenu) {
                    c = ((JPopupMenu)c).getInvoker();
                    continue;
                }
                c = c.getParent();
            }
        }
        System.err.println("BUG: getTextArea() returning null");
        System.err.println("Report this to Slava Pestov <sp@gjt.org>");
        return null;
    }

    public static class backspace
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            if (!textArea.isEditable()) {
                textArea.getToolkit().beep();
                return;
            }
            if (textArea.getSelectionStart() != textArea.getSelectionEnd()) {
                textArea.setSelectedText("");
            } else {
                int caret = textArea.getCaretPosition();
                if (caret == 0) {
                    textArea.getToolkit().beep();
                    return;
                }
                try {
                    textArea.getDocument().remove(caret - 1, 1);
                }
                catch (BadLocationException bl) {
                    bl.printStackTrace();
                }
            }
        }
    }

    public static class backspace_word
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            int start = textArea.getSelectionStart();
            if (start != textArea.getSelectionEnd()) {
                textArea.setSelectedText("");
            }
            int line = textArea.getCaretLine();
            int lineStart = textArea.getLineStartOffset(line);
            int caret = start - lineStart;
            String lineText = textArea.getLineText(textArea.getCaretLine());
            if (caret == 0) {
                if (lineStart == 0) {
                    textArea.getToolkit().beep();
                    return;
                }
                --caret;
            } else {
                String noWordSep = (String)textArea.getDocument().getProperty("noWordSep");
                caret = TextUtilities.findWordStart(lineText, caret, noWordSep);
            }
            try {
                textArea.getDocument().remove(caret + lineStart, start - (caret + lineStart));
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
        }
    }

    public static class delete
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            if (!textArea.isEditable()) {
                textArea.getToolkit().beep();
                return;
            }
            if (textArea.getSelectionStart() != textArea.getSelectionEnd()) {
                textArea.setSelectedText("");
            } else {
                int caret = textArea.getCaretPosition();
                if (caret == textArea.getDocumentLength()) {
                    textArea.getToolkit().beep();
                    return;
                }
                try {
                    textArea.getDocument().remove(caret, 1);
                }
                catch (BadLocationException bl) {
                    bl.printStackTrace();
                }
            }
        }
    }

    public static class delete_word
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            String lineText;
            int line;
            int lineStart;
            int caret;
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            int start = textArea.getSelectionStart();
            if (start != textArea.getSelectionEnd()) {
                textArea.setSelectedText("");
            }
            if ((caret = start - (lineStart = textArea.getLineStartOffset(line = textArea.getCaretLine()))) == (lineText = textArea.getLineText(textArea.getCaretLine())).length()) {
                if (lineStart + caret == textArea.getDocumentLength()) {
                    textArea.getToolkit().beep();
                    return;
                }
                ++caret;
            } else {
                String noWordSep = (String)textArea.getDocument().getProperty("noWordSep");
                caret = TextUtilities.findWordEnd(lineText, caret, noWordSep);
            }
            try {
                textArea.getDocument().remove(start, caret + lineStart - start);
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
        }
    }

    public static class end
    extends AbstractAction {
        private boolean select;

        public end(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int lastOfLine = textArea.getLineEndOffset(textArea.getCaretLine()) - 1;
            int lastVisibleLine = textArea.getFirstLine() + textArea.getVisibleLines();
            lastVisibleLine = lastVisibleLine >= textArea.getLineCount() ? Math.min(textArea.getLineCount() - 1, lastVisibleLine) : (lastVisibleLine -= textArea.getElectricScroll() + 1);
            int lastVisible = textArea.getLineEndOffset(lastVisibleLine) - 1;
            int lastDocument = textArea.getDocumentLength();
            if (caret == lastDocument) {
                textArea.getToolkit().beep();
                return;
            }
            caret = !Boolean.TRUE.equals(textArea.getClientProperty(EditActionMap.SMART_HOME_END_PROPERTY)) ? lastOfLine : (caret == lastVisible ? lastDocument : (caret == lastOfLine ? lastVisible : lastOfLine));
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret);
            } else {
                textArea.setCaretPosition(caret);
            }
        }
    }

    public static class document_end
    extends AbstractAction {
        private boolean select;

        public document_end(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), textArea.getDocumentLength());
            } else {
                textArea.setCaretPosition(textArea.getDocumentLength());
            }
        }
    }

    public static class select_all
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            textArea.selectAll();
        }
    }

    public static class insert_break
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            if (!textArea.isEditable()) {
                textArea.getToolkit().beep();
                return;
            }
            textArea.setSelectedText("\n");
        }
    }

    public static class insert_tab
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            if (!textArea.isEditable()) {
                textArea.getToolkit().beep();
                return;
            }
            textArea.overwriteSetSelectedText("    ");
        }
    }

    public static class home
    extends AbstractAction {
        private boolean select;

        public home(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int firstLine = textArea.getFirstLine();
            int firstOfLine = textArea.getLineStartOffset(textArea.getCaretLine());
            int firstVisibleLine = firstLine == 0 ? 0 : firstLine + textArea.getElectricScroll();
            int firstVisible = textArea.getLineStartOffset(firstVisibleLine);
            if (caret == 0) {
                textArea.getToolkit().beep();
                return;
            }
            caret = !Boolean.TRUE.equals(textArea.getClientProperty(EditActionMap.SMART_HOME_END_PROPERTY)) ? firstOfLine : (caret == firstVisible ? 0 : (caret == firstOfLine ? firstVisible : firstOfLine));
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret);
            } else {
                textArea.setCaretPosition(caret);
            }
        }
    }

    public static class document_home
    extends AbstractAction {
        private boolean select;

        public document_home(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), 0);
            } else {
                textArea.setCaretPosition(0);
            }
        }
    }

    public static class next_char
    extends AbstractAction {
        private boolean select;

        public next_char(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            if (caret == textArea.getDocumentLength()) {
                textArea.getToolkit().beep();
                return;
            }
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret + 1);
            } else {
                textArea.setCaretPosition(caret + 1);
            }
        }
    }

    public static class next_line
    extends AbstractAction {
        private boolean select;

        public next_line(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int line = textArea.getCaretLine();
            if (line == textArea.getLineCount() - 1) {
                textArea.getToolkit().beep();
                return;
            }
            int magic = textArea.getMagicCaretPosition();
            if (magic == -1) {
                magic = textArea.offsetToX(line, caret - textArea.getLineStartOffset(line));
            }
            caret = textArea.getLineStartOffset(line + 1) + textArea.xToOffset(line + 1, magic);
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret);
            } else {
                textArea.setCaretPosition(caret);
            }
            textArea.setMagicCaretPosition(magic);
        }
    }

    public static class next_page
    extends AbstractAction {
        private boolean select;

        public next_page(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            int lineCount = textArea.getLineCount();
            int firstLine = textArea.getFirstLine();
            int visibleLines = textArea.getVisibleLines();
            int line = textArea.getCaretLine();
            if ((firstLine += visibleLines) + visibleLines >= lineCount - 1) {
                firstLine = lineCount - visibleLines;
            }
            textArea.setFirstLine(firstLine);
            int caret = textArea.getLineStartOffset(Math.min(textArea.getLineCount() - 1, line + visibleLines));
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret);
            } else {
                textArea.setCaretPosition(caret);
            }
        }
    }

    public static class next_word
    extends AbstractAction {
        private boolean select;

        public next_word(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String lineText;
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int line = textArea.getCaretLine();
            int lineStart = textArea.getLineStartOffset(line);
            if ((caret -= lineStart) == (lineText = textArea.getLineText(textArea.getCaretLine())).length()) {
                if (lineStart + caret == textArea.getDocumentLength()) {
                    textArea.getToolkit().beep();
                    return;
                }
                ++caret;
            } else {
                String noWordSep = (String)textArea.getDocument().getProperty("noWordSep");
                caret = TextUtilities.findWordEnd(lineText, caret, noWordSep);
            }
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), lineStart + caret);
            } else {
                textArea.setCaretPosition(lineStart + caret);
            }
        }
    }

    public static class overwrite
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea;
            textArea.setOverwriteEnabled(!(textArea = EditActionMap.getTextArea(evt)).isOverwriteEnabled());
        }
    }

    public static class prev_char
    extends AbstractAction {
        private boolean select;

        public prev_char(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            if (caret == 0) {
                textArea.getToolkit().beep();
                return;
            }
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret - 1);
            } else {
                textArea.setCaretPosition(caret - 1);
            }
        }
    }

    public static class prev_line
    extends AbstractAction {
        private boolean select;

        public prev_line(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int line = textArea.getCaretLine();
            if (line == 0) {
                textArea.getToolkit().beep();
                return;
            }
            int magic = textArea.getMagicCaretPosition();
            if (magic == -1) {
                magic = textArea.offsetToX(line, caret - textArea.getLineStartOffset(line));
            }
            caret = textArea.getLineStartOffset(line - 1) + textArea.xToOffset(line - 1, magic);
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret);
            } else {
                textArea.setCaretPosition(caret);
            }
            textArea.setMagicCaretPosition(magic);
        }
    }

    public static class prev_page
    extends AbstractAction {
        private boolean select;

        public prev_page(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            int firstLine = textArea.getFirstLine();
            int visibleLines = textArea.getVisibleLines();
            int line = textArea.getCaretLine();
            if (firstLine < visibleLines) {
                firstLine = visibleLines;
            }
            textArea.setFirstLine(firstLine - visibleLines);
            int caret = textArea.getLineStartOffset(Math.max(0, line - visibleLines));
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret);
            } else {
                textArea.setCaretPosition(caret);
            }
        }
    }

    public static class prev_word
    extends AbstractAction {
        private boolean select;

        public prev_word(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int line = textArea.getCaretLine();
            int lineStart = textArea.getLineStartOffset(line);
            String lineText = textArea.getLineText(textArea.getCaretLine());
            if ((caret -= lineStart) == 0) {
                if (lineStart == 0) {
                    textArea.getToolkit().beep();
                    return;
                }
                --caret;
            } else {
                String noWordSep = (String)textArea.getDocument().getProperty("noWordSep");
                caret = TextUtilities.findWordStart(lineText, caret, noWordSep);
            }
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), lineStart + caret);
            } else {
                textArea.setCaretPosition(lineStart + caret);
            }
        }
    }

    public static class toggle_rect
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea;
            textArea.setSelectionRectangular(!(textArea = EditActionMap.getTextArea(evt)).isSelectionRectangular());
        }
    }

    public static class clip_copy
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            textArea.copy();
        }
    }

    public static class clip_paste
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            textArea.paste();
        }
    }

    public static class clip_cut
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            textArea.cut();
        }
    }

    public static class insert_char
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = EditActionMap.getTextArea(evt);
            String str = evt.getActionCommand();
            if (textArea.isEditable()) {
                textArea.overwriteSetSelectedText(str);
            } else {
                textArea.getToolkit().beep();
            }
        }
    }
}

