/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.lifecycle;

import org.apache.wink.common.internal.lifecycle.JSR250LifecycleManagerUtils;
import org.apache.wink.common.internal.lifecycle.LifecycleManager;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;
import org.apache.wink.common.internal.registry.metadata.ApplicationMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ProviderMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ResourceMetadataCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSR250LifecycleManager<T>
implements LifecycleManager<T> {
    @Override
    public ObjectFactory<T> createObjectFactory(T object) {
        if (object == null) {
            return null;
        }
        Class<?> cls = object.getClass();
        if (JSR250LifecycleManagerUtils.hasJSR250AnnotatedMethod(cls)) {
            return JSR250LifecycleManagerUtils.createSingletonObjectFactory(cls);
        }
        return null;
    }

    @Override
    public ObjectFactory<T> createObjectFactory(Class<T> cls) {
        if (cls == null) {
            return null;
        }
        if (JSR250LifecycleManagerUtils.hasJSR250AnnotatedMethod(cls)) {
            ObjectFactory<T> ret = null;
            if (ApplicationMetadataCollector.isApplication(cls)) {
                ret = JSR250LifecycleManagerUtils.createSingletonObjectFactory(cls);
            } else if (ProviderMetadataCollector.isProvider(cls)) {
                ret = JSR250LifecycleManagerUtils.createSingletonObjectFactory(cls);
            } else if (ResourceMetadataCollector.isStaticResource(cls)) {
                ret = JSR250LifecycleManagerUtils.createPrototypeObjectFactory(cls);
            }
            return ret;
        }
        return null;
    }
}

