/*
 * Decompiled with CFR 0.152.
 */
package org.uppaal.oslc.qm;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.lyo.oslc4j.core.annotation.OslcAllowedValue;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.uppaal.oslc.AuthoredVersionedResource;

@OslcNamespace(value="http://ios.artemis.eu/ns/vv#")
@OslcResourceShape(title="IOS VVCase Resource Shape", describes={"http://ios.artemis.eu/ns/vv#VVCase"})
public class VVCase
extends AuthoredVersionedResource {
    private String status;
    private Link context;
    private final List<Link> log = new ArrayList<Link>();
    private final List<Link> objective = new ArrayList<Link>();
    private final List<Link> testVector = new ArrayList<Link>();
    private final List<Link> usesTestScript = new ArrayList<Link>();

    public VVCase() {
        if (!(this instanceof VVCase)) {
            this.addRdfType(this.getRdfType());
        }
    }

    public VVCase(URI about) {
        super(about);
        if (!(this instanceof VVCase)) {
            this.addRdfType(this.getRdfType());
        }
    }

    @Override
    protected URI getRdfType() {
        return URI.create("http://ios.artemis.eu/ns/vv#VVCase");
    }

    @Override
    public void reorder() {
    }

    @OslcDescription(value="Used to indicate the state of the vv suite based on values defined by the service provider. Most often a read-only property. Defines the overall verdict for the coverage of a VV Suite\u2019s objective by its VV Cases. Before a VV Suite is evaluated the status is either undefined or suspect.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#status")
    @OslcName(value="status")
    @OslcTitle(value="Status")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.String)
    @OslcAllowedValue(value={"pass", "inconclusive", "fail", "error"})
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @OslcDescription(value="The VV Suite defining the context of the VV Case.")
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/vv#context")
    @OslcName(value="context")
    @OslcTitle(value="Context")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://ios.artemis.eu/ns/vv#VVSuite"})
    public Link getContext() {
        return this.context;
    }

    public void setContext(Link context) {
        this.context = context;
    }

    @OslcDescription(value="A set of results from VV Case executions.")
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/vv#log")
    @OslcName(value="log")
    @OslcTitle(value="Log")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://ios.artemis.eu/ns/vv#VVLog"})
    public Link[] getLog() {
        return this.log.toArray(new Link[this.log.size()]);
    }

    public void addLog(Link log) {
        this.log.add(log);
    }

    public void setLog(Link[] log) {
        this.log.clear();
        if (log != null && log.length > 0) {
            this.log.addAll(Arrays.asList(log));
        }
    }

    @OslcDescription(value="The purpose of the VV Case describing what the VV Case aims to find out.")
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/vv#objective")
    @OslcName(value="objective")
    @OslcTitle(value="Objective")
    @OslcOccurs(value=Occurs.OneOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://ios.artemis.eu/ns/vv#VVObjective"})
    public Link[] getObjective() {
        return this.objective.toArray(new Link[this.objective.size()]);
    }

    public void addObjective(Link objective) {
        this.objective.add(objective);
    }

    public void setObjective(Link[] objective) {
        this.objective.clear();
        if (objective != null && objective.length > 0) {
            this.objective.addAll(Arrays.asList(objective));
        }
    }

    @OslcDescription(value="A description of stimuli values for the test scripts and a description of expected results for evaluating the results after the execution of the VV Case.")
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/vv#testVector")
    @OslcName(value="testVector")
    @OslcTitle(value="Test Vector")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/qm#TestVector"})
    public Link[] getTestVector() {
        return this.testVector.toArray(new Link[this.testVector.size()]);
    }

    public void addTestVector(Link testVector) {
        this.testVector.add(testVector);
    }

    public void setTestVector(Link[] testVector) {
        this.testVector.clear();
        if (testVector != null && testVector.length > 0) {
            this.testVector.addAll(Arrays.asList(testVector));
        }
    }

    @OslcDescription(value="An overall result indivating how the overall objective of a VVSuite is covered by the VVCases.")
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/vv#usesTestScript")
    @OslcName(value="usesTestScript")
    @OslcTitle(value="Uses Test Script")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    public Link[] getUsesTestScript() {
        return this.usesTestScript.toArray(new Link[this.usesTestScript.size()]);
    }

    public void addUsesTestScript(Link result) {
        this.usesTestScript.add(result);
    }

    public void setUsesTestScript(Link[] usesTestScript) {
        this.usesTestScript.clear();
        if (usesTestScript != null && usesTestScript.length > 0) {
            this.usesTestScript.addAll(Arrays.asList(usesTestScript));
        }
    }
}

