/*
 * Decompiled with CFR 0.152.
 */
package org.uppaal.oslc;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.uppaal.oslc.BasicResource;

public abstract class VersionedResource
extends BasicResource {
    private final List<URI> prevVersions = new ArrayList<URI>();
    private final List<URI> nextVersions = new ArrayList<URI>();

    public VersionedResource() {
    }

    public VersionedResource(URI about) {
        super(about);
    }

    @OslcDescription(value="Link to a previous (predecessor) version of the resource. Multiple predecessors denote merging.")
    @OslcName(value="prevVersion")
    @OslcTitle(value="Previous Version")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns#prevVersion")
    @OslcValueType(value=ValueType.Resource)
    public URI[] getPrevVersions() {
        return this.prevVersions.toArray(new URI[this.prevVersions.size()]);
    }

    public void addPrevVersion(URI version) {
        if (version == null) {
            throw new RuntimeException("null object added!");
        }
        this.prevVersions.add(version);
    }

    public void setPrevVersions(URI[] versions) {
        this.prevVersions.clear();
        if (versions != null) {
            this.prevVersions.addAll(Arrays.asList(versions));
        }
    }

    @OslcDescription(value="Link to a next (successor) version of the resource. Multiple successors denote branching.")
    @OslcName(value="nextVersion")
    @OslcTitle(value="Next Version")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns#nextVersion")
    @OslcValueType(value=ValueType.Resource)
    public URI[] getNextVersions() {
        return this.prevVersions.toArray(new URI[this.prevVersions.size()]);
    }

    public void addNextVersion(URI version) {
        if (version == null) {
            throw new RuntimeException("null object added!");
        }
        this.nextVersions.add(version);
    }

    public void setNextVersions(URI[] versions) {
        this.nextVersions.clear();
        if (versions != null) {
            this.nextVersions.addAll(Arrays.asList(versions));
        }
    }
}

