/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractCommand;
import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.CommandManager;

public abstract class AbstractTransaction
extends AbstractCommand {
    protected boolean committed = false;
    protected CommandManager commandManager;

    public AbstractTransaction(CommandManager commandManager) {
        this.commandManager = commandManager;
    }

    public void commit() {
        this.commandManager.execute((Command)this);
    }

    public void cancel() {
        assert (!this.committed) : "Cannot cancel committed transaction";
        this.doCancel();
    }

    protected abstract void doCancel();

    protected abstract void doExecute();

    protected abstract void doUndo();

    @Override
    public void execute() {
        if (!this.committed) {
            this.committed = true;
        } else {
            this.doExecute();
        }
    }

    @Override
    public void undo() {
        assert (this.committed) : "Cannot undo uncommitted transaction";
        this.doUndo();
    }

    public void move(int xd, int yd) {
    }
}

