/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.CannotEvaluateException;
import com.uppaal.model.core2.QueryData;

public class QueryResult {
    public static final int OK = 1;
    public static final int MAYBE_OK = 2;
    public static final int MAYBE_NOT_OK = 3;
    public static final int NOT_OK = 4;
    public static final int UNCHECKED = 5;
    private char result;
    private int status;
    private CannotEvaluateException exception = null;
    private String message = null;
    private QueryData data = new QueryData();

    public QueryResult(CannotEvaluateException e) {
        this.result = (char)69;
        this.status = 5;
        this.exception = e;
    }

    public QueryResult(char result) {
        this.result = result;
        switch (result) {
            case 'T': {
                this.status = 1;
                break;
            }
            case 'M': {
                this.status = 2;
                break;
            }
            case 'N': {
                this.status = 3;
                break;
            }
            case 'F': {
                this.status = 4;
                break;
            }
            default: {
                this.status = 5;
            }
        }
    }

    public QueryResult() {
        this('E');
    }

    public char getResult() {
        return this.result;
    }

    public int getStatus() {
        return this.status;
    }

    public void set(CannotEvaluateException exc) {
        this.exception = exc;
    }

    public CannotEvaluateException getException() {
        return this.exception;
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public String getMessage() {
        return this.message;
    }

    public QueryData getData() {
        return this.data;
    }

    public String getStatusString() {
        switch (this.result) {
            case 'T': {
                return "OK";
            }
            case 'M': {
                return "MAYBE_OK";
            }
            case 'N': {
                return "MAYBE_NOT_OK";
            }
            case 'F': {
                return "NOT_OK";
            }
        }
        return "UNCHECKED";
    }

    public String toString() {
        String res = this.getStatusString();
        if (this.message != null) {
            res = res + ": " + this.message;
        }
        return res;
    }
}

