/*
 * Decompiled with CFR 0.152.
 */
package org.swixml;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.HashSet;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.swixml.Factory;
import org.swixml.Parser;
import org.swixml.SwingEngine;
import org.swixml.TagLibrary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaGenerator {
    protected static final String NAMESPACE_PREFIX = "xs";
    protected static final String NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema";

    public static void print(URI uRI, File file) throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        document.setDocumentURI(NAMESPACE_URI);
        Element element = document.createElement("schema");
        document.appendChild(element);
        element.setAttribute("targetNamespace", uRI.toString());
        element.setAttribute("elementFormDefault", "qualified");
        SchemaGenerator.addSwixmlTags(document, element);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(new DOMSource(document), new StreamResult(file));
    }

    public static void print() throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element element = document.createElementNS(NAMESPACE_URI, "schema");
        element.setPrefix(NAMESPACE_PREFIX);
        document.appendChild(element);
        element.setAttribute("targetNamespace", new URI("http://www.swixml.org/2007/Swixml").toString());
        element.setAttribute("elementFormDefault", "qualified");
        SchemaGenerator.addSwixmlTags(document, element);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(new DOMSource(document), new StreamResult(System.out));
    }

    private static Element addSwixmlTags(Document document, Element element) {
        TagLibrary tagLibrary = new SwingEngine().getTaglib();
        for (Object k : new TreeSet(tagLibrary.getTagClasses().keySet())) {
            Element element2 = document.createElementNS(NAMESPACE_URI, "element");
            element2.setPrefix(NAMESPACE_PREFIX);
            element2.setAttribute("name", k.toString());
            element2.appendChild(SchemaGenerator.addSwixmlAttr(document, (Factory)tagLibrary.getTagClasses().get(k)));
            element.appendChild(element2);
        }
        return element;
    }

    private static Element addSwixmlAttr(Document document, Factory factory) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        Element element = document.createElementNS(NAMESPACE_URI, "complexType");
        element.setPrefix(NAMESPACE_PREFIX);
        element.setAttribute("mixed", "true");
        Element element2 = document.createElementNS(NAMESPACE_URI, "sequence");
        element2.setPrefix(NAMESPACE_PREFIX);
        Element element3 = document.createElementNS(NAMESPACE_URI, "any");
        element3.setPrefix(NAMESPACE_PREFIX);
        element2.appendChild(element3);
        element2.setAttribute("minOccurs", "0");
        element2.setAttribute("maxOccurs", "unbounded");
        element.appendChild(element2);
        for (Object e : factory.getSetters()) {
            Element element4 = document.createElementNS(NAMESPACE_URI, "attribute");
            element4.setPrefix(NAMESPACE_PREFIX);
            Method accessibleObject = (Method)e;
            object = accessibleObject.getName();
            if (((String)object).startsWith("set")) {
                object = ((String)object).substring("set".length()).toLowerCase();
            }
            if (((String)object).startsWith("add")) {
                object = ((String)object).substring("add".length()).toLowerCase();
            }
            boolean illegalAccessException = Boolean.TYPE.equals(accessibleObject.getParameterTypes()[0]);
            if (hashSet.contains(object)) continue;
            element4.setAttribute("name", (String)object);
            element4.setAttribute("type", illegalAccessException ? "xs:boolean" : "xs:string");
            element.appendChild(element4);
            hashSet.add(object);
        }
        for (Field field : Parser.class.getFields()) {
            if (!field.getName().startsWith("ATTR_") || field.getName().endsWith("PREFIX") || !Modifier.isFinal(field.getModifiers())) continue;
            object = document.createElementNS(NAMESPACE_URI, "attribute");
            object.setPrefix(NAMESPACE_PREFIX);
            try {
                String string = field.get(Parser.class).toString().toLowerCase();
                if (hashSet.contains(string)) continue;
                object.setAttribute("name", string);
                object.setAttribute("type", "xs:string");
                element.appendChild((Node)object);
                hashSet.add(string);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return element;
    }

    public static void main(String[] stringArray) {
        try {
            SchemaGenerator.print();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (stringArray != null && stringArray.length > 0 && stringArray[0] != null && 0 < stringArray[0].length()) {
                File file = new File(stringArray[0]);
                SchemaGenerator.print(new URI("http://www.swixml.org/2007/Swixml"), file);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

