/*
 * Decompiled with CFR 0.152.
 */
package org.uppaal.oslc.qm;

import java.net.URI;
import org.eclipse.lyo.oslc4j.core.annotation.OslcAllowedValue;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.uppaal.oslc.qm.VVLog;

@OslcNamespace(value="http://www.uppaal.org/ns/qm#")
@OslcResourceShape(title="Uppaal Job Resource Shape", describes={"http://www.uppaal.org/ns/qm#UppaalJob"})
public class UppaalJob
extends VVLog {
    private String searchOrder = "breadth-first";
    private String stateSpaceReduction = "conservative";
    private String stateSpaceRepresentation = "CDS";
    private String diagnosticTrace = "none";
    private String extrapolation = "automatic";
    private boolean stateSpaceReuse = true;
    private double probDeviationLower = 0.05;
    private double probDeviationUpper = 0.05;
    private double falseNegatives = 0.05;
    private double falsePositives = 0.05;
    private double probUncertainty = 0.05;
    private double ratioLowerBound = 0.9;
    private double ratioUpperBound = 1.1;
    private double discretizationStep = 0.01;
    private int traceResolution = 1280;
    private double histBucketWidth = 0.0;
    private double histBucketCount = 0.0;

    public UppaalJob() {
        if (!(this instanceof UppaalJob)) {
            this.addRdfType(this.getRdfType());
        }
    }

    public UppaalJob(URI about) {
        super(about);
        if (!(this instanceof UppaalJob)) {
            this.addRdfType(this.getRdfType());
        }
    }

    @Override
    protected URI getRdfType() {
        return URI.create("http://www.uppaal.org/ns/qm#UppaalJob");
    }

    @Override
    public void reorder() {
    }

    @OslcDescription(value="The option influences the order in which the state space is explored.")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#searchOrder")
    @OslcName(value="searchOrder")
    @OslcTitle(value="Search Order")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcAllowedValue(value={"breadth-first", "depth-first", "random-depth-first"})
    public String getSearchOrder() {
        return this.searchOrder;
    }

    public void setSearchOrder(String searchOrder) {
        this.searchOrder = searchOrder;
    }

    @OslcDescription(value="This option influences how aggressively UPPAAL tries to avoid storing states. There is normally a tradeoff between space and speed.")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#stateSpaceReduction")
    @OslcName(value="stateSpaceReduction")
    @OslcTitle(value="State Space Reduction")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcAllowedValue(value={"none", "conservative", "aggressive"})
    public String getStateSpaceReduction() {
        return this.stateSpaceReduction;
    }

    public void setStateSpaceReduction(String stateSpaceReduction) {
        this.stateSpaceReduction = stateSpaceReduction;
    }

    @OslcDescription(value="This option determines how the state space should be represented in the model checker.")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#stateSpaceRepresentation")
    @OslcName(value="stateSpaceRepresentation")
    @OslcTitle(value="State Space Representation")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcAllowedValue(value={"DBM", "CDS", "under-approximation", "over-approximation"})
    public String getStateSpaceRepresentation() {
        return this.stateSpaceRepresentation;
    }

    public void setStateSpaceRepresentation(String stateSpaceRepresentation) {
        this.stateSpaceRepresentation = stateSpaceRepresentation;
    }

    @OslcDescription(value="This option controls if a counter-example or witnessing trace (if there is one) should be generated during verification. The trace is loaded into the simulator after verification. Enabling trace generation has two side effects: 1) only one property at a time can be verified and 2) symmetry reduction is disabled.")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#diagnosticTrace")
    @OslcName(value="diagnosticTrace")
    @OslcTitle(value="diagnosticTrace")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcAllowedValue(value={"none", "some", "shortest", "fastest"})
    public String getDiagnosticTrace() {
        return this.diagnosticTrace;
    }

    public void setDiagnosticTrace(String diagnosticTrace) {
        this.diagnosticTrace = diagnosticTrace;
    }

    @OslcDescription(value="UPPAAL uses an abstraction techniques called extrapolation to guarantee termination by extrapolating the infinite clock valuations into finite state space partition.")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#extrapolation")
    @OslcName(value="extrapolation")
    @OslcTitle(value="extrapolation")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcAllowedValue(value={"none", "automatic", "difference", "local", "lower", "upper"})
    public String getExtrapolation() {
        return this.extrapolation;
    }

    public void setExtrapolation(String extrapolation) {
        this.extrapolation = extrapolation;
    }

    @OslcDescription(value="When selected, instructs the verifier to (whenever possible) reuse the generated portion of the state space when several properties of the same system are checked.")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#stateSpaceReuse")
    @OslcName(value="stateSpaceReuse")
    @OslcTitle(value="State Space Reuse")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Boolean)
    public boolean getStateSpaceReuse() {
        return this.stateSpaceReuse;
    }

    public void setStateSpaceReuse(boolean stateSpaceReuse) {
        this.stateSpaceReuse = stateSpaceReuse;
    }

    @OslcDescription(value="-delta: used in hypothesis testing to specify the lower bound of indifference region from the specified probability.")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#probDeviationLower")
    @OslcName(value="probDeviationLower")
    @OslcTitle(value="Lower Probability Deviation")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Decimal)
    public double getProbDeviationLower() {
        return this.probDeviationLower;
    }

    public void setProbDeviationLower(double probDeviationLower) {
        this.probDeviationLower = probDeviationLower;
    }

    @OslcDescription(value="+delta: used in hypothesis testing to specify the upper bound of indifference region from the specified probability.")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#probDeviationUpper")
    @OslcName(value="probDeviationUpper")
    @OslcTitle(value="Upper Probability Deviation")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Decimal)
    public double getProbDeviationUpper() {
        return this.probDeviationUpper;
    }

    public void setProbDeviationUpper(double probDeviationUpper) {
        this.probDeviationUpper = probDeviationUpper;
    }

    @OslcDescription(value="alpha: Used in hypothesis testing and probability estimation to specify the level of significance.")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#falseNegatives")
    @OslcName(value="falseNegatives")
    @OslcTitle(value="Probability of False Negatives")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Decimal)
    public double getFalseNegatives() {
        return this.falseNegatives;
    }

    public void setFalseNegatives(double falseNegatives) {
        this.falseNegatives = falseNegatives;
    }

    @OslcDescription(value="beta: used in hypothesis testing to specify the level of significance.")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#falsePositives")
    @OslcName(value="falsePositives")
    @OslcTitle(value="Probability of False Positives")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Decimal)
    public double getFalsePositives() {
        return this.falsePositives;
    }

    public void setFalsePositives(double falsePositives) {
        this.falsePositives = falsePositives;
    }

    @OslcDescription(value="epsilon: used in probability estimation to constrain the probability interval (the half of confidence interval).")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#probUncertainty")
    @OslcName(value="probUncertainty")
    @OslcTitle(value="Probability Uncertainty")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Decimal)
    public double getProbUncertainty() {
        return this.probUncertainty;
    }

    public void setProbUncertainty(double probUncertainty) {
        this.probUncertainty = probUncertainty;
    }

    @OslcDescription(value="u0: used in indirect comparison of two probabilities without probability estimation.")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#ratioLowerBound")
    @OslcName(value="ratioLowerBound")
    @OslcTitle(value="Lower Bound for Probability Ratio")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Decimal)
    public double getRatioLowerBound() {
        return this.ratioLowerBound;
    }

    public void setRatioLowerBound(double ratioLowerBound) {
        this.ratioLowerBound = ratioLowerBound;
    }

    @OslcDescription(value="u1: used in indirect comparison of two probabilities without probability estimation.")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#ratioUpperBound")
    @OslcName(value="ratioUpperBound")
    @OslcTitle(value="Upper Bound for Probability Ratio")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Decimal)
    public double getRatioUpperBound() {
        return this.ratioUpperBound;
    }

    public void setRatioUpperBound(double ratioUpperBound) {
        this.ratioUpperBound = ratioUpperBound;
    }

    @OslcDescription(value="The precision of continuous dynamics (derivative constraint integration step).")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#discretizationStep")
    @OslcName(value="discretizationStep")
    @OslcTitle(value="Discretization Step")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Decimal)
    public double getDiscretizationStep() {
        return this.discretizationStep;
    }

    public void setDiscretizationStep(double discretizationStep) {
        this.discretizationStep = discretizationStep;
    }

    @OslcDescription(value="Resolution of a simulated trajectory, used for compression of visual data.")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#traceResolution")
    @OslcName(value="traceResolution")
    @OslcTitle(value="Trace Resolution")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Decimal)
    public int getTraceResolution() {
        return this.traceResolution;
    }

    public void setTraceResolution(int traceResolution) {
        this.traceResolution = traceResolution;
    }

    @OslcDescription(value="Histogram bucket width (granularity) in terms of time or cost, used in data visualization. Zero means automatic.")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#histBucketWidth")
    @OslcName(value="histBucketWidth")
    @OslcTitle(value="Histogram Bucket Width")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Decimal)
    public double getHistBucketWidth() {
        return this.histBucketWidth;
    }

    public void setHistBucketWidth(double histBucketWidth) {
        this.histBucketWidth = histBucketWidth;
    }

    @OslcDescription(value="Alternative way to specify histogram bucket width (granularity) in terms of bucket count, used in data visualization. Zero means automatic.")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#histBucketCount")
    @OslcName(value="histBucketCount")
    @OslcTitle(value="Histogram Bucket Count")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Decimal)
    public double getHistBucketCount() {
        return this.histBucketCount;
    }

    public void setHistBucketCount(double histBucketCount) {
        this.histBucketCount = histBucketCount;
    }
}

