/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.util;

import com.kitfox.svg.Font;
import com.kitfox.svg.FontFace;
import com.kitfox.svg.Glyph;
import com.kitfox.svg.MissingGlyph;
import java.awt.Canvas;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.util.HashMap;

public class FontSystem
extends Font {
    java.awt.Font sysFont;
    FontMetrics fm;
    HashMap glyphCache = new HashMap();

    public FontSystem(String fontFamily, int fontStyle, int fontWeight, int fontSize) {
        int weight;
        int style;
        switch (fontStyle) {
            case 1: {
                style = 2;
                break;
            }
            default: {
                style = 0;
            }
        }
        switch (fontWeight) {
            case 1: 
            case 2: {
                weight = 1;
                break;
            }
            default: {
                weight = 0;
            }
        }
        this.sysFont = new java.awt.Font(fontFamily, style | weight, fontSize);
        Canvas c = new Canvas();
        this.fm = c.getFontMetrics(this.sysFont);
        FontFace face = new FontFace();
        face.setAscent(this.fm.getAscent());
        face.setDescent(this.fm.getDescent());
        face.setUnitsPerEm(this.fm.charWidth('M'));
        this.setFontFace(face);
    }

    public MissingGlyph getGlyph(String unicode) {
        FontRenderContext frc = new FontRenderContext(null, true, true);
        GlyphVector vec = this.sysFont.createGlyphVector(frc, unicode);
        Glyph glyph = (Glyph)this.glyphCache.get(unicode);
        if (glyph == null) {
            glyph = new Glyph();
            glyph.setPath(vec.getGlyphOutline(0));
            GlyphMetrics gm = vec.getGlyphMetrics(0);
            glyph.setHorizAdvX((int)gm.getAdvanceX());
            glyph.setVertAdvY((int)gm.getAdvanceY());
            glyph.setVertOriginX(0);
            glyph.setVertOriginY(0);
            this.glyphCache.put(unicode, glyph);
        }
        return glyph;
    }
}

