/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.mem.faster.GraphMemFaster;
import com.hp.hpl.jena.shared.ReificationStyle;

public class Factory {
    private Factory() {
    }

    public static Graph createDefaultGraph() {
        return Factory.createDefaultGraph(ReificationStyle.Standard);
    }

    public static Graph createDefaultGraph(ReificationStyle style) {
        return Factory.createGraphMem(style);
    }

    public static Graph createGraphMem() {
        return new GraphMemFaster();
    }

    public static Graph createGraphMem(ReificationStyle style) {
        return new GraphMemFaster(style);
    }

    public static Graph createGraphMemWithTransactionHandler(final TransactionHandler th) {
        GraphMemFaster g = new GraphMemFaster(){

            @Override
            public TransactionHandler getTransactionHandler() {
                return th;
            }
        };
        return g;
    }
}

