/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.system.GanttBar;
import com.uppaal.model.system.concrete.Limit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GanttRow
implements Cloneable {
    public List<GanttBar> bars = new ArrayList<GanttBar>();
    public String label;

    public GanttRow() {
    }

    public GanttRow(String l) {
        this.label = l;
    }

    public void clearRow() {
        this.bars.clear();
    }

    public void addBar(GanttBar bar) {
        if (bar.toTime.isEqualTo(bar.fromTime.getValue())) {
            return;
        }
        if (bar.fromTime.isUnbounded()) {
            return;
        }
        if (this.bars.size() > 0) {
            GanttBar lastBar = this.bars.get(this.bars.size() - 1);
            if (lastBar.value == bar.value && lastBar.fromTime.isLowerBoundOf(bar.fromTime) && lastBar.toTime.isUpperBoundOf(bar.fromTime)) {
                lastBar.toTime = bar.toTime;
                return;
            }
            for (int i = 0; i < this.bars.size(); ++i) {
                GanttBar tmpBar = this.bars.get(i);
                if (!bar.fromTime.isStrictLowerBoundOf(tmpBar.toTime) || !bar.toTime.isStrictUpperBoundOf(tmpBar.fromTime)) continue;
                bar.overlaps = true;
            }
        }
        this.bars.add(bar);
    }

    public int noOfBars() {
        return this.bars.size();
    }

    public GanttBar getFromNum(int i) {
        return this.bars.get(i);
    }

    public void printRowInfo() {
        System.out.println("No of bars " + this.bars.size());
    }

    public void truncate(BigDecimal t) {
        Iterator<GanttBar> i = this.bars.iterator();
        while (i.hasNext()) {
            GanttBar bar = i.next();
            if (bar.toTime.isUnbounded()) {
                bar.toTime.setValue(t);
                bar.toTime.setStrict(true);
            }
            if (bar.fromTime.isUpperBoundOf(t)) {
                i.remove();
                continue;
            }
            if (!bar.toTime.isUpperBoundOf(t)) continue;
            bar.toTime.setValue(t);
            bar.toTime.setStrict(true);
        }
    }

    public Limit maximalNonInfiniteEndTime() {
        Limit tmp = new Limit(new BigDecimal(0), true);
        boolean flagInfinite = true;
        for (GanttBar bar : this.bars) {
            Limit barEndTime = bar.toTime;
            if (barEndTime.isUnbounded() || !barEndTime.isUpperBoundOf(tmp.getValue())) continue;
            tmp = barEndTime;
            flagInfinite = false;
        }
        if (flagInfinite) {
            tmp.setValue(null);
        }
        return tmp;
    }

    public Object clone() throws CloneNotSupportedException {
        GanttRow theClone = new GanttRow(this.label);
        for (GanttBar bar : this.bars) {
            theClone.bars.add((GanttBar)bar.clone());
        }
        return theClone;
    }
}

