/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractTemplate;
import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.BranchPoint;
import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.CommandManager;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.InsertElementCommand;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.QueryList;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.Visitor;
import com.uppaal.model.core2.lsc.Condition;
import com.uppaal.model.core2.lsc.InstanceLine;
import com.uppaal.model.core2.lsc.LscTemplate;
import com.uppaal.model.core2.lsc.Message;
import com.uppaal.model.core2.lsc.Prechart;
import com.uppaal.model.core2.lsc.Update;
import com.uppaal.model.io2.BoundCalc;
import com.uppaal.model.io2.CachedOutputStream;
import com.uppaal.model.io2.XMLWriter;
import com.uppaal.model.io2.XTAWriter;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class Document
extends Node {
    private static String PROP_QUERIES = "queries";
    private static final Pattern node = Pattern.compile("(\\w+)(\\[((\\d+)|@kind=\"(\\w+)\")\\])?");

    public Document() {
        super(null);
    }

    public Document(Element prototype) {
        super(prototype);
        this.setProperty(PROP_QUERIES, new QueryList());
        this.setCommandManager(new CommandManager());
    }

    public String getVersion() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCommandManager().getVersion());
        sb.append(',');
        this.addSubVersion(sb, this.getLocalProperty("declaration"));
        for (Node n = this.getFirst(); n != null; n = n.getNext()) {
            this.addSubVersion(sb, n);
            this.addSubVersion(sb, n.getLocalProperty("declaration"));
        }
        this.addSubVersion(sb, this.getLocalProperty("system"));
        return sb.toString();
    }

    private void addSubVersion(StringBuilder sb, Element element) {
        if (element == null || element.getCommandManager() == null) {
            sb.append("1,");
        } else {
            sb.append(element.getCommandManager().getVersion());
            sb.append(',');
        }
    }

    public QueryList getQueryList() {
        return (QueryList)this.getPropertyValue(PROP_QUERIES);
    }

    public Template createTemplate() {
        return new Template((Element)this.getPropertyValue("#template"));
    }

    public LscTemplate createLscTemplate() {
        return new LscTemplate((Element)this.getPropertyValue("#lscTemplate"));
    }

    public AbstractTemplate getTemplates() {
        return (AbstractTemplate)this.first;
    }

    public AbstractTemplate getTemplate(String name) {
        for (AbstractTemplate template = this.getTemplates(); template != null; template = (AbstractTemplate)template.getNext()) {
            if (!template.getPropertyValue("name").equals(name)) continue;
            return template;
        }
        return null;
    }

    public AbstractTemplate getLastTATemplate() {
        AbstractTemplate template;
        AbstractTemplate template0 = template = this.getTemplates();
        if (!(template instanceof Template)) {
            return null;
        }
        while (template != null) {
            template0 = template;
            if ((template = (AbstractTemplate)template.getNext()) instanceof Template) continue;
            return template0;
        }
        return template0;
    }

    @Override
    public void accept(Visitor visitor) throws Exception {
        visitor.visitDocument(this);
    }

    @Override
    public Document getDocument() {
        return this;
    }

    private Node getChild(Element element, int index, Class<?> c) {
        Node child;
        if (!(element instanceof Node)) {
            return null;
        }
        for (child = ((Node)element).getFirst(); child != null && !c.isInstance(child); child = child.getNext()) {
        }
        while (child != null && index > 1) {
            while ((child = child.getNext()) != null && !c.isInstance(child)) {
            }
            --index;
        }
        return child;
    }

    public Element resolveXPath(String path) {
        Scanner scanner = new Scanner(path);
        Element current = this;
        block64: while (scanner.hasNext() && current != null) {
            scanner.findInLine(node);
            MatchResult result = scanner.match();
            String token = result.group(1);
            String s = result.group(4);
            int index = s == null ? 1 : Integer.parseInt(s);
            String kind = result.group(5);
            switch (token) {
                case "project": {
                    current = this;
                    continue block64;
                }
                case "nta": {
                    current = this;
                    continue block64;
                }
                case "declaration": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "template": {
                    current = this.getChild(current, index, Template.class);
                    continue block64;
                }
                case "instantiation": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "system": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "name": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "parameter": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "location": {
                    current = this.getChild(current, index, Location.class);
                    continue block64;
                }
                case "branchpoint": {
                    current = this.getChild(current, index, BranchPoint.class);
                    continue block64;
                }
                case "init": {
                    continue block64;
                }
                case "transition": {
                    current = this.getChild(current, index, Edge.class);
                    continue block64;
                }
                case "label": {
                    if (kind != null) {
                        current = current.getLocalProperty(kind);
                        continue block64;
                    }
                    Property child = null;
                    for (String k : current.getXMLLabelKinds()) {
                        if (!current.isPropertyLocal(k)) continue;
                        if (index == 1) {
                            child = current.getProperty(k);
                        }
                        --index;
                    }
                    current = child;
                    continue block64;
                }
                case "urgent": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "source": {
                    continue block64;
                }
                case "target": {
                    continue block64;
                }
                case "nail": {
                    current = this.getChild(current, index, Nail.class);
                    continue block64;
                }
                case "lscTemplate": {
                    current = this.getChild(current, index, LscTemplate.class);
                    continue block64;
                }
                case "type": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "mode": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "role": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "yloccoord": {
                    continue block64;
                }
                case "instance": {
                    current = this.getChild(current, index, InstanceLine.class);
                    continue block64;
                }
                case "prechart": {
                    current = this.getChild(current, index, Prechart.class);
                    continue block64;
                }
                case "message": {
                    current = this.getChild(current, index, Message.class);
                    continue block64;
                }
                case "condition": {
                    current = this.getChild(current, index, Condition.class);
                    continue block64;
                }
                case "update": {
                    current = this.getChild(current, index, Update.class);
                    continue block64;
                }
                case "anchor": {
                    continue block64;
                }
                case "temperature": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "lsclocation": {
                    current = current.getProperty(token);
                    continue block64;
                }
            }
            return null;
        }
        return current;
    }

    public static boolean merge(AbstractTemplate source, AbstractTemplate target) {
        ArrayList<InsertElementCommand> cmd = new ArrayList<InsertElementCommand>();
        if (target instanceof Template) {
            if (source instanceof Template) {
                Node child;
                BoundCalc measurer = new BoundCalc();
                Rectangle2D tb = measurer.getBounds(target);
                Rectangle2D sb = measurer.getBounds(source);
                if (sb != null && tb != null) {
                    final int dx = (int)Math.round(tb.getMaxX() - sb.getMinX());
                    final int dy = (int)Math.round(tb.getMinY() - sb.getMinY());
                    source.acceptSafe(new AbstractVisitor(){

                        @Override
                        public void visitElement(Element element) throws Exception {
                            super.visitElement(element);
                            if (element.isPropertyLocal("x")) {
                                element.setProperty("x", element.getX() + dx);
                            }
                            if (element.isPropertyLocal("y")) {
                                element.setProperty("y", element.getY() + dy);
                            }
                        }
                    });
                }
                boolean initExists = false;
                for (child = target.getFirst(); child != null; child = child.getNext()) {
                    if (!child.hasFlag("init")) continue;
                    initExists = true;
                }
                child = source.getFirst();
                while (child != null) {
                    child.remove();
                    child.importInto(target);
                    if (initExists && child.hasFlag("init")) {
                        child.setProperty("init", null);
                    }
                    cmd.add(new InsertElementCommand(target.getCommandManager(), target, target.getLast(), child));
                    child = source.getFirst();
                }
                if (cmd.isEmpty()) {
                    return false;
                }
                Command[] commands = cmd.toArray(new Command[cmd.size()]);
                target.getCommandManager().execute(commands);
                return true;
            }
        } else if (target instanceof LscTemplate && source instanceof LscTemplate) {
            return false;
        }
        return false;
    }

    public void save(String path) throws IOException {
        this.save(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        block11: {
            CachedOutputStream out = new CachedOutputStream(file);
            try {
                String s = file.getName();
                String lname = s.toLowerCase();
                if (lname.endsWith(".xml")) {
                    this.accept(new XMLWriter(out));
                    break block11;
                }
                if (lname.endsWith(".xta")) {
                    File gfxFile = new File(file.getAbsoluteFile().getParentFile(), s.replaceFirst("(?i).xta$", ".ugi"));
                    CachedOutputStream gfx = new CachedOutputStream(gfxFile);
                    try {
                        XTAWriter writer = new XTAWriter(out);
                        this.accept(writer);
                        this.accept(writer.createUGIWriter(gfx));
                        break block11;
                    }
                    finally {
                        ((OutputStream)gfx).flush();
                        ((OutputStream)gfx).close();
                    }
                }
                throw new IOException("The file extension was not recognised (Only .xml and .xta are supported).");
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new IOException(e.getMessage());
            }
            finally {
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
            }
        }
    }

    @Override
    public String getXPathTag() {
        return "/nta";
    }
}

