/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.utils;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import org.apache.wink.common.internal.http.Accept;
import org.apache.wink.common.internal.providers.header.AcceptHeaderDelegate;
import org.eclipse.lyo.oslc4j.core.model.OslcMediaType;

public class AcceptUtil {
    public static final MediaType[] OSLC_ACCEPTABLE = new MediaType[]{OslcMediaType.APPLICATION_RDF_XML_TYPE, OslcMediaType.TEXT_TURTLE_TYPE, OslcMediaType.APPLICATION_XML_TYPE, OslcMediaType.APPLICATION_JSON_TYPE, OslcMediaType.APPLICATION_X_OSLC_COMPACT_XML_TYPE};

    public static MediaType matchMediaType(HttpServletRequest request) {
        return AcceptUtil.matchMediaType(request, OSLC_ACCEPTABLE);
    }

    public static MediaType matchMediaType(HttpServletRequest request, MediaType[] acceptable) {
        if (acceptable == null || acceptable.length == 0) {
            return null;
        }
        String accept = request.getHeader("Accept");
        if (accept == null) {
            return acceptable[0];
        }
        AcceptHeaderDelegate delegate = new AcceptHeaderDelegate();
        Accept a = delegate.fromString(accept);
        for (MediaType nextRequested : a.getSortedMediaTypes()) {
            for (MediaType nextAcceptable : acceptable) {
                if (!nextRequested.isCompatible(nextAcceptable)) continue;
                return nextAcceptable;
            }
        }
        return null;
    }
}

