/*
 * Decompiled with CFR 0.152.
 */
package org.uppaal.oslc.rm;

import java.net.URI;
import org.eclipse.lyo.oslc4j.core.annotation.OslcAllowedValue;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.uppaal.oslc.AuthoredVersionedResource;

@OslcNamespace(value="http://ios.artemis.eu/ns/rm#")
@OslcResourceShape(title="Requirement Resource Shape", describes={"http://ios.artemis.eu/ns/rm#Requirement"})
public class Requirement
extends AuthoredVersionedResource {
    private Link partOf;
    private String specificationType = "Natural language";
    private String specificationLanguage = "English";

    public Requirement() {
        if (!(this instanceof Requirement)) {
            this.addRdfType(this.getRdfType());
        }
    }

    public Requirement(URI about) {
        super(about);
        if (!(this instanceof Requirement)) {
            this.addRdfType(this.getRdfType());
        }
    }

    @Override
    public void reorder() {
    }

    @Override
    protected URI getRdfType() {
        return URI.create("http://ios.artemis.eu/ns/rm#Requirement");
    }

    @OslcDescription(value="Reference to the larger requirement (collection) which contains this requirement.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/partOf")
    @OslcName(value="partOf")
    @OslcTitle(value="Part of")
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    public Link getPartOf() {
        return this.partOf;
    }

    public void setPartOf(Link partOf) {
        this.partOf = partOf;
    }

    @OslcDescription(value="Text defining the type of requirement specification: Natural language, Semiformal or Formal.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/rm#specificationType")
    @OslcName(value="specificationType")
    @OslcTitle(value="Specification Type")
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcAllowedValue(value={"Natural language", "Semiformal", "Formal"})
    public String getSpecificationType() {
        return this.specificationType;
    }

    public final void setSpecificationType(String specType) {
        this.specificationType = specType;
    }

    @OslcDescription(value="The name of the requirement specification language used for the description of the requirement.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/rm#specificationLanguage")
    @OslcName(value="specificationLanguage")
    @OslcTitle(value="Specification Language")
    @OslcValueType(value=ValueType.String)
    public String getSpecificationLanguage() {
        return this.specificationLanguage;
    }

    public final void setSpecificationLanguage(String specLang) {
        this.specificationLanguage = specLang;
    }
}

