/*
 * Decompiled with CFR 0.152.
 */
package org.uppaal.oslc.qm;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.uppaal.oslc.qm.VVOutcome;

@OslcNamespace(value="http://www.uppaal.org/ns/qm#")
@OslcResourceShape(title="Uppaal Plot Resource Shape", describes={"http://www.uppaal.org/ns/qm#UppaalPlot"})
public abstract class UppaalPlot
extends VVOutcome {
    private List<String> axisLabel = new ArrayList<String>();
    private List<Link> dataSet = new ArrayList<Link>();

    public UppaalPlot() {
        if (!(this instanceof UppaalPlot)) {
            this.addRdfType(this.getRdfType());
        }
    }

    public UppaalPlot(URI about) {
        super(about);
        if (!(this instanceof UppaalPlot)) {
            this.addRdfType(this.getRdfType());
        }
    }

    @Override
    protected URI getRdfType() {
        return URI.create("http://www.uppaal.org/ns/qm#UppaalPlot");
    }

    @OslcDescription(value="Axis label for each dimension of a data point.")
    @OslcPropertyDefinition(value="http://www.uppaal.org/ns/qm#axisLabel")
    @OslcName(value="axisLabel")
    @OslcTitle(value="Axis Label")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.String)
    public String[] getAxisLabel() {
        return this.axisLabel.toArray(new String[this.axisLabel.size()]);
    }

    public void addAxisLabel(String axisLabel) {
        this.axisLabel.add(axisLabel);
    }

    public void setAxisLabel(String[] axisLabel) {
        this.axisLabel.clear();
        if (axisLabel != null && axisLabel.length > 0) {
            this.axisLabel.addAll(Arrays.asList(axisLabel));
        }
    }

    @OslcDescription(value="A set of outcomes produced as a result of a test or analysis task.")
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/vv#dataSet")
    @OslcName(value="dataSet")
    @OslcTitle(value="Data Set")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://www.uppaal.org/ns/qm#UppaalDataSet"})
    public Link[] getDataSet() {
        return this.dataSet.toArray(new Link[this.dataSet.size()]);
    }

    public void addDataSet(Link dataSet) {
        this.dataSet.add(dataSet);
    }

    public void setDataSet(Link[] dataSet) {
        this.dataSet.clear();
        if (dataSet != null && dataSet.length > 0) {
            this.dataSet.addAll(Arrays.asList(dataSet));
        }
    }
}

