/*
 * Decompiled with CFR 0.152.
 */
package org.uppaal.oslc.qm;

import java.net.URI;
import org.eclipse.lyo.oslc4j.core.annotation.OslcAllowedValue;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.uppaal.oslc.qm.VVOutcome;

@OslcNamespace(value="http://www.uppaal.org/ns/qm#")
@OslcResourceShape(title="Uppaal Data Set Resource Shape", describes={"http://www.uppaal.org/ns/qm#UppaalDataSet"})
public abstract class UppaalDataSet
extends VVOutcome {
    private String color;
    private String symbol;
    private String line;
    private String filling;
    private Link source;

    public UppaalDataSet() {
        if (!(this instanceof UppaalDataSet)) {
            this.addRdfType(this.getRdfType());
        }
    }

    public UppaalDataSet(URI about) {
        super(about);
        if (!(this instanceof UppaalDataSet)) {
            this.addRdfType(this.getRdfType());
        }
    }

    @Override
    protected URI getRdfType() {
        return URI.create("http://www.uppaal.org/ns/qm#UppaalDataSet");
    }

    @OslcDescription(value="Color associated with the display of this dataset, encoded in octal or hexadecimal notation.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#color")
    @OslcName(value="color")
    @OslcTitle(value="Color")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.String)
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @OslcDescription(value="Shape of a symbol associated with the display of this dataset.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#symbol")
    @OslcName(value="symbol")
    @OslcTitle(value="Symbol Shape")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.String)
    @OslcAllowedValue(value={"p", "d", "t", "u", "v", "w", "c", "r"})
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @OslcDescription(value="Shape of a line associated with the display of this dataset.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#line")
    @OslcName(value="line")
    @OslcTitle(value="Line Shape")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.String)
    @OslcAllowedValue(value={"l", "k", "m", "n"})
    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }

    @OslcDescription(value="Shape of a line associated with the display of this dataset.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#filling")
    @OslcName(value="filling")
    @OslcTitle(value="Area Filling")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.String)
    @OslcAllowedValue(value={"b", "i", "a"})
    public String getFilling() {
        return this.filling;
    }

    public void setFilling(String filling) {
        this.filling = filling;
    }

    @OslcDescription(value="Source file containing a set of coordinates of data points.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#source")
    @OslcName(value="source")
    @OslcTitle(value="Source")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Resource)
    public Link getSource() {
        return this.source;
    }

    public void setSource(Link source) {
        this.source = source;
    }
}

