/*
 * Decompiled with CFR 0.152.
 */
package org.uppaal.oslc;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

public abstract class BasicResource
extends AbstractResource {
    private final ArrayList<URI> rdfTypes = new ArrayList();
    private URI serviceProvider;
    private URI instanceShape;
    private String identifier;
    public static final Comparator<URI> compareUri = new Comparator<URI>(){

        @Override
        public int compare(URI o1, URI o2) {
            String s1 = o1.getPath().substring(o1.getPath().lastIndexOf(47) + 1);
            String s2 = o2.getPath().substring(o2.getPath().lastIndexOf(47) + 1);
            try {
                return Long.valueOf(s1).compareTo(Long.valueOf(s2));
            }
            catch (NumberFormatException e) {
                return s1.compareTo(s2);
            }
        }
    };
    public static final Comparator<Link> compareLinks = new Comparator<Link>(){

        @Override
        public int compare(Link o1, Link o2) {
            return compareUri.compare((URI)o1.getValue(), (URI)o2.getValue());
        }
    };
    public static final Comparator<Link> compareLinkLabels = new Comparator<Link>(){

        @Override
        public int compare(Link o1, Link o2) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
    };

    public BasicResource() {
        this.rdfTypes.add(this.getRdfType());
    }

    public BasicResource(URI about) {
        super(about);
        this.rdfTypes.add(this.getRdfType());
    }

    public abstract void reorder();

    public void importFromProviders(String[] oldProviders) {
    }

    protected abstract URI getRdfType();

    @OslcDescription(value="The resource type URIs.")
    @OslcPropertyDefinition(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    @OslcTitle(value="Type")
    @OslcName(value="type")
    @OslcValueType(value=ValueType.Resource)
    public URI[] getRdfTypes() {
        return this.rdfTypes.toArray(new URI[this.rdfTypes.size()]);
    }

    public void addRdfType(URI rdfType) {
        if (rdfType == null) {
            throw new RuntimeException("null object added!");
        }
        this.rdfTypes.add(rdfType);
    }

    public void setRdfTypes(URI[] rdfTypes) {
        this.rdfTypes.clear();
        if (rdfTypes != null) {
            this.rdfTypes.addAll(Arrays.asList(rdfTypes));
        }
    }

    @OslcDescription(value="The scope of a resource is a URI for the resource's OSLC Service Provider.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcName(value="serviceProvider")
    @OslcTitle(value="Service Provider")
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/core#ServiceProvider"})
    public URI getServiceProvider() {
        return this.serviceProvider;
    }

    public void setServiceProvider(URI serviceProviderURI) {
        this.serviceProvider = serviceProviderURI;
    }

    @OslcDescription(value="Resource Shape that provides hints as to resource property value-types and allowed values. ")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcName(value="instanceShape")
    @OslcTitle(value="Instance Shape")
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/core#ResourceShape"})
    public URI getInstanceShape() {
        return this.instanceShape;
    }

    public void setInstanceShape(URI instanceShape) {
        this.instanceShape = instanceShape;
    }

    @OslcDescription(value="A unique identifier for a resource. Assigned by the service provider when a resource is created. Not intended for end-user display.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcReadOnly
    @OslcName(value="identifier")
    @OslcTitle(value="Identifier")
    @OslcValueType(value=ValueType.String)
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    protected void toHtmlRow(StringBuilder s, String title, Object value) {
        String v;
        if (value == null) {
            return;
        }
        if (value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                this.toHtmlRow(s, title, Array.get(value, i));
            }
            return;
        }
        if (value instanceof Collection) {
            for (Object v2 : (Collection)value) {
                this.toHtmlRow(s, title, v2);
            }
            return;
        }
        if (value instanceof String) {
            v = (String)value;
        } else if (value instanceof Date) {
            v = DateFormat.getDateTimeInstance().format((Date)value);
        } else if (value instanceof URI) {
            String uri = value.toString();
            v = "<a href=\"" + uri + "\">" + uri + "</a>";
        } else if (value instanceof Link) {
            String label = ((Link)value).getLabel();
            String uri = ((URI)((Link)value).getValue()).toString();
            v = "<a href=\"" + uri + "\">" + label + "</a>";
        } else {
            v = value.toString();
        }
        s.append("<tr>\n\t<th>").append(title).append(":</th>\n\t<td>").append(v).append("</td>\n</tr>\n");
    }

    public final String toHtmlRows() {
        StringBuilder s = new StringBuilder();
        for (Method method : ((Object)((Object)this)).getClass().getMethods()) {
            String title;
            OslcTitle t = method.getAnnotation(OslcTitle.class);
            String string = title = t != null ? t.value() : null;
            if (title == null) continue;
            try {
                Object value = method.invoke((Object)this, new Object[0]);
                this.toHtmlRow(s, title, value);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(BasicResource.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(BasicResource.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(BasicResource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return s.toString();
    }
}

