/*
 * Decompiled with CFR 0.152.
 */
package org.uppaal.oslc;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.uppaal.oslc.BasicResource;

public abstract class AuthoredResource
extends BasicResource {
    private String shortTitle;
    private String title;
    private String description;
    private URI creator;
    private final Collection<URI> contributors = new ArrayList<URI>();
    private final Collection<String> subjects = new ArrayList<String>();
    private Date created = new Date(System.currentTimeMillis());
    private Date modified = new Date(System.currentTimeMillis());

    public AuthoredResource() {
    }

    public AuthoredResource(URI about) {
        super(about);
    }

    @OslcDescription(value="Short name identifying a resource, often used as an abbreviated identifier for presentation to end-users. SHOULD include only content that is valid inside an XHTML <span> element.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#shortTitle")
    @OslcName(value="shortTitle")
    @OslcTitle(value="Short Title")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getShortTitle() {
        return this.shortTitle;
    }

    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    @OslcDescription(value="Title (reference: Dublin Core) or often a single line summary of the resource represented as rich text in XHTML content.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcName(value="title")
    @OslcTitle(value="Title")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @OslcDescription(value="Descriptive text (reference: Dublin Core) about resource represented as rich text in XHTML content.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcName(value="description")
    @OslcTitle(value="Description")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @OslcDescription(value="An entity primarily responsible for making the resource.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcName(value="creator")
    @OslcTitle(value="Creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.97/Person"})
    public URI getCreator() {
        return this.creator;
    }

    public void setCreator(URI creator) {
        this.creator = creator;
    }

    @OslcDescription(value="An entity responsible for making contributions to the resource.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcName(value="contributor")
    @OslcTitle(value="Contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.97/Person"})
    public URI[] getContributors() {
        return this.contributors.toArray(new URI[this.contributors.size()]);
    }

    public void addContributor(URI contributor) {
        if (contributor == null) {
            throw new RuntimeException("null object added!");
        }
        this.contributors.add(contributor);
    }

    public void setContributors(URI[] contributors) {
        this.contributors.clear();
        if (contributors != null) {
            this.contributors.addAll(Arrays.asList(contributors));
        }
    }

    @OslcDescription(value="Tag or keyword for a resource. Each occurrence of a dcterms:subject property denotes an additional tag for the resource.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcName(value="subject")
    @OslcTitle(value="Subject")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/subject")
    @OslcReadOnly(value=false)
    @OslcValueType(value=ValueType.String)
    public String[] getSubjects() {
        return this.subjects.toArray(new String[this.subjects.size()]);
    }

    public void addSubject(String subject) {
        if (subject == null) {
            throw new RuntimeException("null object added!");
        }
        this.subjects.add(subject);
    }

    public void setSubjects(String[] subjects) {
        this.subjects.clear();
        if (subjects != null) {
            this.subjects.addAll(Arrays.asList(subjects));
        }
    }

    @OslcDescription(value="Timestamp of resource creation.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcReadOnly(value=true)
    @OslcName(value="created")
    @OslcTitle(value="Created")
    @OslcValueType(value=ValueType.DateTime)
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    @OslcDescription(value="Timestamp last latest resource modification.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/modified")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcName(value="modified")
    @OslcTitle(value="Modified")
    @OslcValueType(value=ValueType.DateTime)
    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }
}

