/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.provider.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNotQueryResult;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.exception.MessageExtractor;
import org.eclipse.lyo.oslc4j.core.model.Error;
import org.eclipse.lyo.oslc4j.core.model.OslcMediaType;
import org.eclipse.lyo.oslc4j.core.model.ResponseInfo;
import org.eclipse.lyo.oslc4j.core.model.ResponseInfoArray;
import org.eclipse.lyo.oslc4j.provider.jena.ErrorHandler;
import org.eclipse.lyo.oslc4j.provider.jena.JenaModelHelper;
import org.eclipse.lyo.oslc4j.provider.jena.RdfXmlAbbreviatedWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOslcRdfXmlProvider {
    private static final Logger logger = Logger.getLogger(AbstractOslcRdfXmlProvider.class.getName());
    public static final String OSLC4J_ALWAYS_XML_ABBREV = "org.eclipse.lyo.oslc4j.alwaysXMLAbbrev";
    private static final Annotation[] ANNOTATIONS_EMPTY_ARRAY = new Annotation[0];
    private static final Class<Error> CLASS_OSLC_ERROR = Error.class;
    private static final ErrorHandler ERROR_HANDLER = new ErrorHandler();
    @Context
    private HttpHeaders httpHeaders;
    @Context
    protected HttpServletRequest httpServletRequest;
    @Context
    private Providers providers;

    protected AbstractOslcRdfXmlProvider() {
    }

    protected static boolean isWriteable(Class<?> type, Annotation[] annotations, MediaType actualMediaType, MediaType ... requiredMediaTypes) {
        if (type.getAnnotation(OslcResourceShape.class) != null || type.getAnnotation(OslcNotQueryResult.class) != null) {
            if (annotations != null && (annotations.length > 0 || CLASS_OSLC_ERROR != type)) {
                for (Annotation annotation : annotations) {
                    if (!(annotation instanceof Produces)) continue;
                    Produces producesAnnotation = (Produces)annotation;
                    for (String value : producesAnnotation.value()) {
                        for (MediaType requiredMediaType : requiredMediaTypes) {
                            if (!requiredMediaType.isCompatible(MediaType.valueOf((String)value))) continue;
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            for (MediaType requiredMediaType : requiredMediaTypes) {
                if (!requiredMediaType.isCompatible(actualMediaType)) continue;
                return true;
            }
        }
        return false;
    }

    protected void writeTo(Object[] objects, MediaType baseMediaType, MultivaluedMap<String, Object> map, OutputStream outputStream, Map<String, Object> properties, String descriptionURI, String responseInfoURI, ResponseInfo<?> responseInfo) throws WebApplicationException {
        String serializationLanguage = this.getSerializationLanguage(baseMediaType);
        try {
            Model model = JenaModelHelper.createJenaModel(descriptionURI, responseInfoURI, responseInfo, objects, properties);
            RdfXmlAbbreviatedWriter writer = null;
            writer = serializationLanguage.equals("RDF/XML-ABBREV") ? new RdfXmlAbbreviatedWriter() : model.getWriter(serializationLanguage);
            writer.setProperty("showXmlDeclaration", "false");
            writer.setErrorHandler(ERROR_HANDLER);
            if (!serializationLanguage.equals("TURTLE")) {
                String xmlDeclaration = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
                outputStream.write(xmlDeclaration.getBytes());
            }
            writer.write(model, outputStream, null);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, MessageExtractor.getMessage((String)"ErrorSerializingResource"), exception);
            throw new WebApplicationException((Throwable)exception);
        }
    }

    protected void writeTo(boolean queryResult, Object[] objects, MediaType baseMediaType, MultivaluedMap<String, Object> map, OutputStream outputStream) throws WebApplicationException {
        String method;
        boolean isClientSide = false;
        try {
            this.httpServletRequest.getMethod();
        }
        catch (RuntimeException e) {
            isClientSide = true;
        }
        String descriptionURI = null;
        String responseInfoURI = null;
        if (queryResult && !isClientSide && "GET".equals(method = this.httpServletRequest.getMethod())) {
            responseInfoURI = descriptionURI = OSLC4JUtils.resolveURI((HttpServletRequest)this.httpServletRequest, (boolean)true);
            String queryString = this.httpServletRequest.getQueryString();
            if (queryString != null && AbstractOslcRdfXmlProvider.isOslcQuery(queryString)) {
                responseInfoURI = responseInfoURI + "?" + queryString;
            }
        }
        String serializationLanguage = this.getSerializationLanguage(baseMediaType);
        Map properties = isClientSide ? null : (Map)this.httpServletRequest.getAttribute("org.eclipse.lyo.oslc4j.selected.properties");
        String nextPageURI = isClientSide ? null : (String)this.httpServletRequest.getAttribute("org.eclipse.lyo.oslc4j.next.page");
        Integer totalCount = isClientSide ? null : (Integer)this.httpServletRequest.getAttribute("org.eclipse.lyo.oslc4j.total.count");
        ResponseInfoArray responseInfo = new ResponseInfoArray(null, properties, totalCount, nextPageURI);
        try {
            Model model = JenaModelHelper.createJenaModel(descriptionURI, responseInfoURI, responseInfo, objects, properties);
            RdfXmlAbbreviatedWriter writer = null;
            writer = serializationLanguage.equals("RDF/XML-ABBREV") ? new RdfXmlAbbreviatedWriter() : model.getWriter(serializationLanguage);
            writer.setProperty("showXmlDeclaration", "false");
            writer.setErrorHandler(ERROR_HANDLER);
            if (!serializationLanguage.equals("TURTLE")) {
                String xmlDeclaration = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
                outputStream.write(xmlDeclaration.getBytes());
            }
            writer.write(model, outputStream, null);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, MessageExtractor.getMessage((String)"ErrorSerializingResource"), exception);
            throw new WebApplicationException((Throwable)exception);
        }
    }

    private String getSerializationLanguage(MediaType baseMediaType) {
        if (OslcMediaType.TEXT_TURTLE_TYPE.equals((Object)baseMediaType)) {
            return "TURTLE";
        }
        if (OslcMediaType.APPLICATION_RDF_XML_TYPE.isCompatible(baseMediaType) && !"true".equals(System.getProperty(OSLC4J_ALWAYS_XML_ABBREV))) {
            return "RDF/XML";
        }
        return "RDF/XML-ABBREV";
    }

    protected static boolean isReadable(Class<?> type, MediaType actualMediaType, MediaType ... requiredMediaTypes) {
        if (type.getAnnotation(OslcResourceShape.class) != null) {
            for (MediaType requiredMediaType : requiredMediaTypes) {
                if (!requiredMediaType.isCompatible(actualMediaType)) continue;
                return true;
            }
        }
        return false;
    }

    protected Object[] readFrom(Class<?> type, MediaType mediaType, MultivaluedMap<String, String> map, InputStream inputStream) throws WebApplicationException {
        Model model = ModelFactory.createDefaultModel();
        RDFReader reader = null;
        reader = mediaType != null && mediaType.isCompatible(OslcMediaType.TEXT_TURTLE_TYPE) ? model.getReader("TURTLE") : model.getReader();
        reader.setErrorHandler((RDFErrorHandler)ERROR_HANDLER);
        try {
            reader.read(model, inputStream, "");
            return JenaModelHelper.fromJenaModel(model, type);
        }
        catch (Exception exception) {
            throw new WebApplicationException((Throwable)exception, this.buildBadRequestResponse(exception, mediaType, map));
        }
    }

    protected Response buildBadRequestResponse(Exception exception, MediaType initialErrorMediaType, MultivaluedMap<String, ?> map) {
        MediaType determinedErrorMediaType = this.determineErrorMediaType(initialErrorMediaType, map);
        Error error = new Error();
        error.setStatusCode(String.valueOf(Response.Status.BAD_REQUEST.getStatusCode()));
        error.setMessage(exception.getMessage());
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
        return responseBuilder.type(determinedErrorMediaType).entity((Object)error).build();
    }

    private MediaType determineErrorMediaType(MediaType initialErrorMediaType, MultivaluedMap<String, ?> map) {
        block5: {
            try {
                List acceptableMediaTypes = this.httpHeaders.getAcceptableMediaTypes();
                if (acceptableMediaTypes != null) {
                    for (MediaType acceptableMediaType : acceptableMediaTypes) {
                        if (!this.isAcceptableMediaType(acceptableMediaType)) continue;
                        return acceptableMediaType;
                    }
                }
            }
            catch (NullPointerException exception) {
                Object acceptObject;
                if (map == null || !((acceptObject = map.getFirst((Object)"Accept")) instanceof String)) break block5;
                String[] accepts = acceptObject.toString().split(",");
                double winningQ = 0.0;
                MediaType winningMediaType = null;
                for (String accept : accepts) {
                    double q;
                    MediaType acceptMediaType = MediaType.valueOf((String)accept);
                    if (!this.isAcceptableMediaType(acceptMediaType)) continue;
                    String stringQ = (String)acceptMediaType.getParameters().get("q");
                    double d = q = stringQ == null ? 1.0 : Double.parseDouble(stringQ);
                    if (Double.compare(q, 0.0) <= 0 || winningMediaType != null && Double.compare(q, winningQ) <= 0) continue;
                    winningMediaType = acceptMediaType;
                    winningQ = q;
                }
                if (winningMediaType == null) break block5;
                return winningMediaType;
            }
        }
        return initialErrorMediaType;
    }

    private boolean isAcceptableMediaType(MediaType mediaType) {
        return !mediaType.isWildcardType() && !mediaType.isWildcardSubtype() && this.providers.getMessageBodyWriter(CLASS_OSLC_ERROR, CLASS_OSLC_ERROR, ANNOTATIONS_EMPTY_ARRAY, mediaType) != null;
    }

    protected static boolean isOslcQuery(String parmString) {
        boolean containsOslcParm = false;
        String[] uriParts = parmString.toLowerCase().split("oslc\\.", 2);
        if (uriParts.length > 1) {
            containsOslcParm = true;
        }
        return containsOslcParm;
    }
}

