/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import com.uppaal.model.core2.AbstractLocation;
import com.uppaal.model.core2.AbstractTemplate;
import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.BranchPoint;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Query;
import com.uppaal.model.core2.QueryList;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.lsc.Condition;
import com.uppaal.model.core2.lsc.InstanceLine;
import com.uppaal.model.core2.lsc.LscElement;
import com.uppaal.model.core2.lsc.LscTemplate;
import com.uppaal.model.core2.lsc.Message;
import com.uppaal.model.core2.lsc.Prechart;
import com.uppaal.model.core2.lsc.Update;
import com.uppaal.model.io2.UXMLResolver;
import java.awt.Color;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLWriter
extends AbstractVisitor {
    protected int counter;
    protected XMLStreamWriter writer;
    protected Map<AbstractLocation, String> locations = new HashMap<AbstractLocation, String>();
    protected Map<InstanceLine, String> instances = new HashMap<InstanceLine, String>();
    private ArrayList<Integer> yLocCoord = new ArrayList();
    protected String init;
    int depth = 0;

    public XMLWriter(OutputStream stream) throws XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        this.writer = outputFactory.createXMLStreamWriter(stream, "utf-8");
    }

    public XMLWriter(Writer writer) throws XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        this.writer = outputFactory.createXMLStreamWriter(writer);
    }

    protected void indent() throws XMLStreamException {
        this.writer.writeCharacters("\r\n");
        for (int i = 0; i < this.depth; ++i) {
            this.writer.writeCharacters("\t");
        }
    }

    protected void writePropertyAsElement(Element element, String property, boolean optional) throws XMLStreamException {
        String value = (String)element.getPropertyValue(property);
        if (!optional || value != null && value.length() > 0) {
            this.indent();
            this.writer.writeStartElement(property);
            this.writeAttributes(element.getProperty(property));
            if (value != null) {
                this.writer.writeCharacters(value);
            }
            this.writer.writeEndElement();
        }
    }

    protected void writePropertyAsLabel(Element element, String name) throws XMLStreamException {
        String str;
        Property property = element.getProperty(name);
        if (property != null && (str = property.getValue().toString().trim()).length() > 0) {
            this.indent();
            this.writer.writeStartElement("label");
            this.writer.writeAttribute("kind", name);
            this.writeAttributes(property);
            this.writer.writeCharacters(str);
            this.writer.writeEndElement();
        }
    }

    protected void writeAttributes(Element element) throws XMLStreamException {
        Property color;
        Object x = element.getPropertyValue("x");
        Object y = element.getPropertyValue("y");
        if (element.getParent() instanceof Message) {
            Float f = (Float)element.getPropertyValue("f");
            Message message = (Message)element.getParent();
            int s = message.getSource().getX();
            int t = message.getTarget().getX();
            x = new Integer((int)((float)s + f.floatValue() * (float)(t - s)));
        }
        if (x != null) {
            this.writer.writeAttribute("x", x.toString());
        }
        if (y != null) {
            this.writer.writeAttribute("y", y.toString());
        }
        if ((color = element.getLocalProperty("color")) != null) {
            int rgb = ((Color)color.getValue()).getRGB() & 0xFFFFFF;
            String hex = String.format("#%06x", rgb);
            this.writer.writeAttribute("color", hex);
        }
    }

    protected boolean hasFlag(Element element, String property) {
        Object value = element.getPropertyValue(property);
        return value != null && (Boolean)value != false;
    }

    protected void writeFlag(Element element, String property) throws XMLStreamException {
        if (this.hasFlag(element, property)) {
            this.indent();
            this.writer.writeEmptyElement(property);
        }
    }

    @Override
    public void visitDocument(Document document) throws Exception {
        this.writer.writeStartDocument("utf-8", "1.0");
        UXMLResolver xmlResolver = new UXMLResolver();
        String dtdString = "<!DOCTYPE nta PUBLIC '" + xmlResolver.getPublicID() + "' '" + xmlResolver.getSystemID() + "'>";
        this.indent();
        this.writer.writeDTD(dtdString);
        this.indent();
        this.writer.writeStartElement("nta");
        ++this.depth;
        this.writePropertyAsElement(document, "declaration", true);
        super.visitDocument(document);
        this.writePropertyAsElement(document, "instantiation", true);
        this.writePropertyAsElement(document, "system", false);
        document.getQueryList().accept(this);
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
        this.indent();
        this.writer.writeEndDocument();
        this.writer.close();
    }

    @Override
    public void visitTemplate(AbstractTemplate template) throws Exception {
        if (template instanceof Template) {
            this.visitTemplate((Template)template);
        } else {
            this.visitTemplate((LscTemplate)template);
        }
    }

    private void visitTemplate(Template template) throws Exception {
        this.indent();
        ++this.depth;
        this.writer.writeStartElement("template");
        this.writePropertyAsElement(template, "name", false);
        this.writePropertyAsElement(template, "parameter", true);
        this.writePropertyAsElement(template, "declaration", true);
        template.accept(new AbstractVisitor(){

            @Override
            public void visitLocation(Location location) throws Exception {
                location.accept(XMLWriter.this);
            }
        });
        template.accept(new AbstractVisitor(){

            @Override
            public void visitBranchPoint(BranchPoint branchPoint) throws Exception {
                branchPoint.accept(XMLWriter.this);
            }
        });
        if (this.init != null) {
            this.indent();
            this.writer.writeEmptyElement("init");
            this.writer.writeAttribute("ref", this.init);
            this.init = null;
        }
        template.accept(new AbstractVisitor(){

            @Override
            public void visitEdge(Edge edge) throws Exception {
                edge.accept(XMLWriter.this);
            }
        });
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    private void visitTemplate(LscTemplate template) throws Exception {
        this.indent();
        ++this.depth;
        this.writer.writeStartElement("lsc");
        this.writePropertyAsElement(template, "name", false);
        this.writePropertyAsElement(template, "parameter", true);
        this.writePropertyAsElement(template, "type", false);
        this.writePropertyAsElement(template, "mode", false);
        this.writePropertyAsElement(template, "declaration", true);
        this.yLocCoord = template.getYLocCoord();
        int size = this.yLocCoord.size();
        for (int i = 0; i < size; ++i) {
            this.indent();
            this.writer.writeEmptyElement("yloccoord");
            this.writer.writeAttribute("number", String.valueOf(i));
            this.writer.writeAttribute("y", this.yLocCoord.get(i).toString());
        }
        template.accept(new AbstractVisitor(){

            @Override
            public void visitInstanceLine(InstanceLine instance) throws Exception {
                instance.accept(XMLWriter.this);
            }
        });
        template.accept(new AbstractVisitor(){

            @Override
            public void visitPrechart(Prechart prechart) throws Exception {
                prechart.accept(XMLWriter.this);
            }
        });
        template.accept(new AbstractVisitor(){

            @Override
            public void visitMessage(Message message) throws Exception {
                message.accept(XMLWriter.this);
            }
        });
        template.accept(new AbstractVisitor(){

            @Override
            public void visitCondition(Condition condition) throws Exception {
                condition.accept(XMLWriter.this);
            }
        });
        template.accept(new AbstractVisitor(){

            @Override
            public void visitUpdate(Update update) throws Exception {
                update.accept(XMLWriter.this);
            }
        });
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitLocation(Location location) throws Exception {
        String id = "id" + this.counter++;
        this.indent();
        ++this.depth;
        this.writer.writeStartElement("location");
        this.writer.writeAttribute("id", id);
        this.writeAttributes(location);
        this.locations.put(location, id);
        this.writePropertyAsElement(location, "name", true);
        for (String kind : location.getXMLLabelKinds()) {
            this.writePropertyAsLabel(location, kind);
        }
        this.writeFlag(location, "urgent");
        this.writeFlag(location, "committed");
        if (this.hasFlag(location, "init")) {
            this.init = id;
        }
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitBranchPoint(BranchPoint branchPoint) throws Exception {
        String id = "id" + this.counter++;
        this.indent();
        this.writer.writeStartElement("branchpoint");
        this.writer.writeAttribute("id", id);
        this.writeAttributes(branchPoint);
        this.locations.put(branchPoint, id);
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitEdge(Edge edge) throws Exception {
        this.indent();
        ++this.depth;
        this.writer.writeStartElement("transition");
        if (!edge.hasFlag("controllable")) {
            this.writer.writeAttribute("controllable", "false");
        }
        this.writeAttributes(edge);
        this.indent();
        this.writer.writeEmptyElement("source");
        this.writer.writeAttribute("ref", this.locations.get(edge.getSource()));
        this.indent();
        this.writer.writeEmptyElement("target");
        this.writer.writeAttribute("ref", this.locations.get(edge.getTarget()));
        for (String kind : edge.getXMLLabelKinds()) {
            this.writePropertyAsLabel(edge, kind);
        }
        super.visitEdge(edge);
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitNail(Nail nail) throws Exception {
        this.indent();
        this.writer.writeEmptyElement("nail");
        this.writeAttributes(nail);
    }

    @Override
    public void visitInstanceLine(InstanceLine instance) throws Exception {
        String id = "id" + this.counter++;
        this.indent();
        ++this.depth;
        this.writer.writeStartElement("instance");
        this.writer.writeAttribute("id", id);
        this.writeAttributes(instance);
        this.instances.put(instance, id);
        this.writePropertyAsElement(instance, "name", true);
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitPrechart(Prechart prechart) throws Exception {
        this.indent();
        ++this.depth;
        this.writer.writeStartElement("prechart");
        this.writeAttributes(prechart);
        this.location(prechart);
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    private void location(LscElement element) throws Exception {
        Integer value = this.yLocCoord.indexOf(element.getY());
        this.indent();
        this.writer.writeStartElement("lsclocation");
        this.writer.writeCharacters(value.toString());
        this.writer.writeEndElement();
    }

    @Override
    public void visitMessage(Message message) throws Exception {
        this.indent();
        ++this.depth;
        this.writer.writeStartElement("message");
        this.writeAttributes(message);
        this.indent();
        this.writer.writeEmptyElement("source");
        this.writer.writeAttribute("ref", this.instances.get(message.getSource()));
        this.indent();
        this.writer.writeEmptyElement("target");
        this.writer.writeAttribute("ref", this.instances.get(message.getTarget()));
        this.location(message);
        this.writePropertyAsLabel(message, "message");
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitCondition(Condition condition) throws Exception {
        this.indent();
        ++this.depth;
        this.writer.writeStartElement("condition");
        this.writeAttributes(condition);
        ArrayList<InstanceLine> anchors = condition.getAnchors();
        for (InstanceLine anchor : anchors) {
            this.indent();
            this.writer.writeEmptyElement("anchor");
            this.writer.writeAttribute("instanceid", this.instances.get(anchor));
        }
        this.location(condition);
        this.temperature(condition);
        this.writePropertyAsLabel(condition, "condition");
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    private void temperature(Condition condition) throws Exception {
        boolean value = (Boolean)condition.getPropertyValue("hot");
        String temperature = value ? "hot" : "cold";
        this.indent();
        this.writer.writeStartElement("temperature");
        this.writer.writeCharacters(temperature);
        this.writer.writeEndElement();
    }

    @Override
    public void visitUpdate(Update update) throws Exception {
        this.indent();
        this.writer.writeStartElement("update");
        this.writeAttributes(update);
        if (update.getAnchoredToCondition() != null) {
            Integer y = update.getAnchoredToCondition().getY();
            update.setProperty("y", y);
        }
        ++this.depth;
        this.indent();
        this.writer.writeEmptyElement("anchor");
        this.writer.writeAttribute("instanceid", this.instances.get(update.getAnchor()));
        this.location(update);
        this.writePropertyAsLabel(update, "update");
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitQueries(QueryList queries) throws Exception {
        this.indent();
        this.writer.writeStartElement("queries");
        ++this.depth;
        super.visitQueries(queries);
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitQuery(Query query) throws Exception {
        this.indent();
        this.writer.writeStartElement("query");
        ++this.depth;
        this.indent();
        this.writer.writeStartElement("formula");
        this.writer.writeCharacters(query.getFormula());
        this.writer.writeEndElement();
        this.indent();
        this.writer.writeStartElement("comment");
        this.writer.writeCharacters(query.getComment());
        this.writer.writeEndElement();
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }
}

