/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.gui.Main;
import com.uppaal.model.LayoutVisitor;
import com.uppaal.model.core2.Constants;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.lsc.LscConstants;
import com.uppaal.model.core2.lsc.LscElement;
import com.uppaal.model.io2.UGIReader;
import com.uppaal.model.io2.XMLReader;
import com.uppaal.model.io2.XTAReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;

public class PrototypeDocument
extends Element
implements Constants,
LscConstants {
    public PrototypeDocument() {
        super(null);
        Object[] properties = new Object[]{"declaration", "", "declaration:#xml.tag", "declaration!", "declaration:errors", new ArrayList(), "system", "", "system:#xml.tag", "system!", "system:errors", new ArrayList(), "#template", new Element(null), "#template/#xml.tag", "template", "#template/name", "", "#template/name:#xml.tag", "name!", "#template/name:errors", new ArrayList(), "#template/parameter", "", "#template/parameter:#xml.tag", "parameter!", "#template/parameter:errors", new ArrayList(), "#template/declaration", "", "#template/declaration:#xml.tag", "declaration!", "#template/declaration:errors", new ArrayList(), "#template/#location", new Element(null), "#template/#location/#xml.tag", "location", "#template/#location/name", "", "#template/#location/name:#xml.tag", "name!", "#template/#location/name:x", 0, "#template/#location/name:y", 0, "#template/#location/name:errors", new ArrayList(), "#template/#location/invariant", "", "#template/#location/invariant:#xml.tag", "label[@kind=\"invariant\"]", "#template/#location/invariant:x", 0, "#template/#location/invariant:y", 0, "#template/#location/invariant:errors", new ArrayList(), "#template/#location/exponentialrate", "", "#template/#location/exponentialrate:#xml.tag", "label[@kind=\"exponentialrate\"]", "#template/#location/exponentialrate:x", 0, "#template/#location/exponentialrate:y", 0, "#template/#location/exponentialrate:errors", new ArrayList(), "#template/#location/init", false, "#template/#location/committed", false, "#template/#location/urgent", false, "#template/#location/x", 0, "#template/#location/y", 0, "#template/#location/color", STATE_FILL_COL, "#template/#location/comments", "", "#template/#location/comments:#xml.tag", "label[@kind=\"comments\"]", "#template/#location/comments:x", 0, "#template/#location/comments:y", 0, "#template/#location/comments:errors", new ArrayList(), "#template/#location/comments:color", COMMENTS_COL, "#template/#location/comments:font", FONT, "#template/#location/testcodeEnter", "", "#template/#location/testcodeEnter:#xml.tag", "label[@kind=\"testcodeEnter\"]", "#template/#location/testcodeLeave", "", "#template/#location/testcodeLeave:#xml.tag", "label[@kind=\"testcodeLeave\"]", "#template/#branchpoint", new Element(null), "#template/#branchpoint/#xml.tag", "branchpoint", "#template/#branchpoint/x", 0, "#template/#branchpoint/y", 0, "#template/#branchpoint/color", STATE_FILL_COL, "#template/#edge", new Element(null), "#template/#edge/#xml.tag", "transition", "#template/#edge/select", "", "#template/#edge/select:#xml.tag", "label[@kind=\"select\"]", "#template/#edge/select:x", 0, "#template/#edge/select:y", 0, "#template/#edge/select:errors", new ArrayList(), "#template/#edge/guard", "", "#template/#edge/guard:#xml.tag", "label[@kind=\"guard\"]", "#template/#edge/guard:x", 0, "#template/#edge/guard:y", 0, "#template/#edge/guard:errors", new ArrayList(), "#template/#edge/synchronisation", "", "#template/#edge/synchronisation:#xml.tag", "label[@kind=\"synchronisation\"]", "#template/#edge/synchronisation:x", 0, "#template/#edge/synchronisation:y", 0, "#template/#edge/synchronisation:errors", new ArrayList(), "#template/#edge/assignment", "", "#template/#edge/assignment:#xml.tag", "label[@kind=\"assignment\"]", "#template/#edge/assignment:x", 0, "#template/#edge/assignment:y", 0, "#template/#edge/assignment:errors", new ArrayList(), "#template/#edge/probability", "", "#template/#edge/probability:#xml.tag", "label[@kind=\"probability\"]", "#template/#edge/probability:x", 0, "#template/#edge/probability:y", 0, "#template/#edge/probability:errors", new ArrayList(), "#template/#edge/comments", "", "#template/#edge/comments:#xml.tag", "label[@kind=\"comments\"]", "#template/#edge/controllable", true, "#template/#edge/color", TRANS_COL, "#template/#edge/comments:x", 0, "#template/#edge/comments:y", 0, "#template/#edge/comments:errors", new ArrayList(), "#template/#edge/comments:color", COMMENTS_COL, "#template/#edge/comments:font", FONT, "#template/#edge/#nail", new Element(null), "#template/#edge/#nail/x", 0, "#template/#edge/#nail/y", 0, "#template/#edge/testcode", "", "#template/#edge/testcode:#xml.tag", "label[@kind=\"testcode\"]", "#template/#location/name:color", STATE_LABEL_COL, "#template/#location/name:font", FONT, "#template/#location/invariant:color", INVARIANT_COL, "#template/#location/invariant:font", FONT, "#template/#location/exponentialrate:color", EXPONENTIALRATE_COL, "#template/#location/exponentialrate:font", FONT, "#template/#edge/select:color", SELECT_COL, "#template/#edge/select:font", FONT, "#template/#edge/guard:color", GUARD_COL, "#template/#edge/guard:font", FONT, "#template/#edge/synchronisation:color", SYNC_COL, "#template/#edge/synchronisation:font", FONT, "#template/#edge/assignment:color", ASSIGN_COL, "#template/#edge/assignment:font", FONT, "#template/#edge/probability:color", PROB_COL, "#template/#edge/probability:font", FONT, "#lscTemplate", new Element(null), "#lscTemplate/name", "", "#lscTemplate/name:#xml.tag", "name!", "#lscTemplate/name:errors", new ArrayList(), "#lscTemplate/parameter", "", "#lscTemplate/parameter:#xml.tag", "parameter!", "#lscTemplate/parameter:errors", new ArrayList(), "#lscTemplate/declaration", "", "#lscTemplate/declaration:#xml.tag", "declaration!", "#lscTemplate/declaration:errors", new ArrayList(), "#lscTemplate/type", "Universal", "#lscTemplate/type:#xml.tag", "type!", "#lscTemplate/type:errors", new ArrayList(), "#lscTemplate/mode", "Invariant", "#lscTemplate/mode:#xml.tag", "mode!", "#lscTemplate/mode:errors", new ArrayList(), "#lscTemplate/#instance", new LscElement(null), "#lscTemplate/#instance:#xml.tag", "instance", "#lscTemplate/#instance/name", "", "#lscTemplate/#instance/name:#xml.tag", "name!", "#lscTemplate/#instance/name:x", 0, "#lscTemplate/#instance/name:y", 0, "#lscTemplate/#instance/name:font", FONT, "#lscTemplate/#instance/name:errors", new ArrayList(), "#lscTemplate/#instance/x", 0, "#lscTemplate/#instance/y", 0, "#lscTemplate/#instance/color", INSTANCE_FILL_COL, "#lscTemplate/#message", new LscElement(null), "#lscTemplate/#message:#xml.tag", "message", "#lscTemplate/#message/message", "", "#lscTemplate/#message/message:#xml.tag", "label[@kind=\"message\"]", "#lscTemplate/#message/message:x", 0, "#lscTemplate/#message/message:f", Float.valueOf(10.0f), "#lscTemplate/#message/message:y", 0, "#lscTemplate/#message/message:font", FONT, "#lscTemplate/#message/message:color", MESSAGE_LABEL_COL, "#lscTemplate/#message/x", 0, "#lscTemplate/#message/y", 0, "#lscTemplate/#message/message:errors", new ArrayList(), "#lscTemplate/#message/color", MESSAGE_COL, "#lscTemplate/#prechart", new LscElement(null), "#lscTemplate/#prechart:#xml.tag", "prechart", "#lscTemplate/#prechart/x", 0, "#lscTemplate/#prechart/y", 0, "#lscTemplate/#prechart/color", PRECHART_COL, "#lscTemplate/#condition", new LscElement(null), "#lscTemplate/#condition:#xml.tag", "condition", "#lscTemplate/#condition/condition", "", "#lscTemplate/#condition/condition:font", FONT, "#lscTemplate/#condition/condition:errors", new ArrayList(), "#lscTemplate/#condition/x", 0, "#lscTemplate/#condition/y", 0, "#lscTemplate/#condition/hot", false, "#lscTemplate/#condition/color", null, "#lscTemplate/#update", new LscElement(null), "#lscTemplate/#update:#xml.tag", "update", "#lscTemplate/#update/update", "", "#lscTemplate/#update/update:font", FONT, "#lscTemplate/#update/update:errors", new ArrayList(), "#lscTemplate/#update/x", 0, "#lscTemplate/#update/y", 0, "#lscTemplate/#update/color", UPDATE_COL};
        this.setProperties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document load(URL url) throws IOException {
        try (InputStream stream = "file".equals(url.getProtocol()) ? new FileInputStream(url.getPath()) : url.openStream();){
            Document document;
            String path = url.getPath().toLowerCase();
            if (path.endsWith(".xml")) {
                document = new XMLReader(stream).parse(this);
            } else if (path.endsWith(".xta") || path.endsWith(".ta")) {
                XTAReader reader = new XTAReader(stream);
                document = reader.parse(this);
                try {
                    URL gfxUrl;
                    String gfxPath = url.getPath().replaceFirst("\\....?$", ".ugi");
                    if (url.getQuery() != null) {
                        gfxPath = gfxPath + '?' + url.getQuery();
                    }
                    try (InputStream gfxStream = "file".equals((gfxUrl = new URL(url.getProtocol(), url.getHost(), gfxPath)).getProtocol()) ? new FileInputStream(gfxUrl.getPath()) : gfxUrl.openStream();){
                        UGIReader ugiReader = new UGIReader(gfxStream);
                        ugiReader.parse(document);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                if (reader.getErrors() != null) {
                    Main.infoError.errorMessage(reader.getErrors());
                }
            } else {
                document = new XMLReader(stream).parse(this);
            }
            document.acceptSafe(new LayoutVisitor());
            Document document2 = document;
            return document2;
        }
    }
}

