/*
 * Decompiled with CFR 0.152.
 */
package org.uppaal.oslc.qm;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.lyo.oslc4j.core.annotation.OslcAllowedValue;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.uppaal.oslc.AuthoredVersionedResource;

@OslcNamespace(value="http://ios.artemis.eu/ns/vv#")
@OslcResourceShape(title="VVSuite Resource Shape", describes={"http://ios.artemis.eu/ns/vv#VVSuite"})
public class VVSuite
extends AuthoredVersionedResource {
    private String status;
    private final List<Link> usesTestCase = new ArrayList<Link>();
    private Link objective;
    private final List<Link> result = new ArrayList<Link>();
    private Link arbiter;
    private final List<Link> configuration = new ArrayList<Link>();
    private final List<Link> environmentComponent = new ArrayList<Link>();
    private Link scheduler;
    private final List<Link> subjectComponent = new ArrayList<Link>();

    public VVSuite() {
        if (!(this instanceof VVSuite)) {
            this.addRdfType(this.getRdfType());
        }
    }

    public VVSuite(URI about) {
        super(about);
        if (!(this instanceof VVSuite)) {
            this.addRdfType(this.getRdfType());
        }
    }

    @Override
    protected URI getRdfType() {
        return URI.create("http://ios.artemis.eu/ns/vv#VVSuite");
    }

    @Override
    public void reorder() {
        Collections.sort(this.usesTestCase, compareLinkLabels);
        Collections.sort(this.result, compareLinkLabels);
        Collections.sort(this.configuration, compareLinkLabels);
        Collections.sort(this.environmentComponent, compareLinkLabels);
        Collections.sort(this.subjectComponent, compareLinkLabels);
    }

    @OslcDescription(value="Used to indicate the state of the vv suite based on values defined by the service provider. Most often a read-only property. Defines the overall verdict for the coverage of a VV Suite\u2019s objective by its VV Cases. Before a VV Suite is evaluated the status is either undefined or suspect.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#status")
    @OslcName(value="status")
    @OslcTitle(value="Status")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.String)
    @OslcAllowedValue(value={"pass", "inconclusive", "fail", "error", "suspect"})
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @OslcDescription(value="Test Case run by the Test Execution Record. It is likely that the target resource will be an oslc_qm:TestCase but that is not necessarily the case. Represents the case relationship of a VV Suite to a VV Case.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#usesTestCase")
    @OslcName(value="usesTestCase")
    @OslcTitle(value="Uses Test Case")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://ios.artemis.eu/ns/vv#VVCase"})
    public Link[] getUsesTestCase() {
        return this.usesTestCase.toArray(new Link[this.usesTestCase.size()]);
    }

    public void addUsesTestCase(Link testCase) {
        this.usesTestCase.add(testCase);
    }

    public void setUsesTestCase(Link[] usesTestCase) {
        this.usesTestCase.clear();
        if (usesTestCase != null && usesTestCase.length > 0) {
            this.usesTestCase.addAll(Arrays.asList(usesTestCase));
        }
    }

    @OslcDescription(value="An overall objective for a VVSuite.")
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/vv#objective")
    @OslcName(value="objective")
    @OslcTitle(value="Objective")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://ios.artemis.eu/ns/vv#VVObjective"})
    public Link getObjective() {
        return this.objective;
    }

    public void setObjective(Link objective) {
        this.objective = objective;
    }

    @OslcDescription(value="An overall result indicating how the overall objective of a VV Suite is covered by the VV Cases.")
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/vv#result")
    @OslcName(value="result")
    @OslcTitle(value="Result")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://ios.artemis.eu/ns/vv#VVLog"})
    public Link[] getResult() {
        return this.result.toArray(new Link[this.result.size()]);
    }

    public void addResult(Link result) {
        this.result.add(result);
    }

    public void setResult(Link[] result) {
        this.result.clear();
        if (result != null && result.length > 0) {
            this.result.addAll(Arrays.asList(result));
        }
    }

    @OslcDescription(value="Defines the implementation of an arbiter.")
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/vv#arbiter")
    @OslcName(value="arbiter")
    @OslcTitle(value="Arbiter")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://ios.artemis.eu/ns/am#Behavior"})
    public Link getArbiter() {
        return this.arbiter;
    }

    public void setArbiter(Link arbiter) {
        this.arbiter = arbiter;
    }

    @OslcDescription(value="A set of components each being a type that defines an assembly of contained prototypes of environment components and subject components as configurations for the VV Suite.")
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/vv#configuration")
    @OslcName(value="configuration")
    @OslcTitle(value="Configuration")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://ios.artemis.eu/ns/am#Component"})
    public Link[] getConfiguration() {
        return this.configuration.toArray(new Link[this.configuration.size()]);
    }

    public void addConfiguration(Link configuration) {
        this.configuration.add(configuration);
    }

    public void setConfiguration(Link[] configuration) {
        this.configuration.clear();
        if (configuration != null && configuration.length > 0) {
            this.configuration.addAll(Arrays.asList(configuration));
        }
    }

    @OslcDescription(value="A set of components that are used in the configuration to provide stimuli to the components that are subject in the VV effort.")
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/vv#environmentComponent")
    @OslcName(value="environmentComponent")
    @OslcTitle(value="Environment Component")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://ios.artemis.eu/ns/am#Component"})
    public Link[] getEnvironmentComponents() {
        return this.environmentComponent.toArray(new Link[this.environmentComponent.size()]);
    }

    public void addEnvironmentComponent(Link environmentComponent) {
        this.environmentComponent.add(environmentComponent);
    }

    public void setEnvironmentComponents(Link[] environmentComponent) {
        this.environmentComponent.clear();
        if (environmentComponent != null && environmentComponent.length > 0) {
            this.environmentComponent.addAll(Arrays.asList(environmentComponent));
        }
    }

    @OslcDescription(value="Defines the implementation of a scheduler.")
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/vv#scheduler")
    @OslcName(value="scheduler")
    @OslcTitle(value="Scheduler")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://ios.artemis.eu/ns/am#Behavior"})
    public Link getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Link scheduler) {
        this.scheduler = scheduler;
    }

    @OslcDescription(value="A set of components, which are subject to the VV Suite such as a system under test.")
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/vv#subjectComponent")
    @OslcName(value="subjectComponent")
    @OslcTitle(value="Subject Component")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://ios.artemis.eu/ns/am#Component"})
    public Link[] getSubjectComponent() {
        return this.subjectComponent.toArray(new Link[this.subjectComponent.size()]);
    }

    public void addSubjectComponent(Link subjectComponent) {
        this.subjectComponent.add(subjectComponent);
    }

    public void setSubjectComponent(Link[] subjectComponent) {
        this.subjectComponent.clear();
        if (subjectComponent != null && subjectComponent.length > 0) {
            this.subjectComponent.addAll(Arrays.asList(subjectComponent));
        }
    }
}

