/*
 * Decompiled with CFR 0.152.
 */
package org.uppaal.oslc.qm;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.uppaal.oslc.AuthoredVersionedResource;

@OslcNamespace(value="http://ios.artemis.eu/ns/vv#")
@OslcResourceShape(title="IOS VVObjective Resource Shape", describes={"http://ios.artemis.eu/ns/vv#VVObjective"})
public class VVObjective
extends AuthoredVersionedResource {
    private final List<Link> vvCase = new ArrayList<Link>();
    private final List<Link> target = new ArrayList<Link>();

    public VVObjective() {
        if (!(this instanceof VVObjective)) {
            this.addRdfType(this.getRdfType());
        }
    }

    public VVObjective(URI about) {
        super(about);
        if (!(this instanceof VVObjective)) {
            this.addRdfType(this.getRdfType());
        }
    }

    @Override
    public void reorder() {
        Collections.sort(this.vvCase, compareLinkLabels);
        Collections.sort(this.target, compareLinkLabels);
    }

    @Override
    protected URI getRdfType() {
        return URI.create("http://ios.artemis.eu/ns/vv#VVCase");
    }

    @OslcDescription(value="The set of VV Cases related to the VV Objective.")
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/vv#vvCase")
    @OslcName(value="vvCase")
    @OslcTitle(value="VVCase")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://ios.artemis.eu/ns/vv#VVCase"})
    public Link[] getVVCase() {
        return this.vvCase.toArray(new Link[this.vvCase.size()]);
    }

    public void addVVCase(Link vvCase) {
        this.vvCase.add(vvCase);
    }

    public void setVVCase(Link[] vvCase) {
        this.vvCase.clear();
        if (vvCase != null && vvCase.length > 0) {
            this.vvCase.addAll(Arrays.asList(vvCase));
        }
    }

    @OslcDescription(value="The set of referenced properties which define the target of the objective.")
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/vv#target")
    @OslcName(value="target")
    @OslcTitle(value="target")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://ios.artemis.eu/ns/rm#Requirement", "http://ios.artemis.eu/ns/tm#SatisfyLink", "http://ios.artemis.eu/ns/tm#AllocateLink", "http://ios.artemis.eu/ns/tm#DeriveLink", "http://ios.artemis.eu/ns/tm#ImplementationLink", "http://ios.artemis.eu/ns/tm#RealizeLink", "http://ios.artemis.eu/ns/tm#RefineLink"})
    public Link[] getTarget() {
        return this.target.toArray(new Link[this.target.size()]);
    }

    public void addTarget(Link target) {
        this.target.add(target);
    }

    public void setTarget(Link[] target) {
        this.target.clear();
        if (target != null && target.length > 0) {
            this.target.addAll(Arrays.asList(target));
        }
    }
}

