/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import com.uppaal.model.core2.Query;
import com.uppaal.model.core2.QueryList;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class QueryListURLReader {
    private final URL url;

    public QueryListURLReader(URL url) {
        this.url = url;
    }

    public QueryList read() throws IOException {
        QueryList queryList = new QueryList();
        InputStream is = "file".equals(this.url.getProtocol()) ? new FileInputStream(this.url.getPath()) : this.url.openStream();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));){
            while (reader.ready()) {
                String s = reader.readLine();
                if (s.length() <= 0 || s.startsWith("//")) continue;
                String comment = "";
                if (s.equals("/*")) {
                    s = reader.readLine();
                    if (!s.equals("*/")) {
                        comment = comment + s;
                        s = reader.readLine();
                        while (!s.equals("*/")) {
                            comment = comment + '\n' + s;
                            s = reader.readLine();
                        }
                        comment = comment.replaceAll("([^\\\\]?)\\\\/", "$1/");
                        comment = comment.replaceAll("\\\\\\\\", "\\\\");
                        comment = QueryListURLReader.decode(comment);
                    }
                    s = reader.readLine();
                }
                StringBuffer formula = new StringBuffer();
                if (!s.equals("//NO_QUERY")) {
                    while (s.endsWith("\\")) {
                        formula.append(s.substring(0, s.length() - 1)).append('\n');
                        s = reader.readLine();
                    }
                    formula.append(s);
                }
                Query query = new Query(new String(formula), comment);
                queryList.addLast(query);
            }
        }
        return queryList;
    }

    private static String decode(String s) {
        int i = 0;
        StringBuilder buf = new StringBuilder(s);
        while ((i = buf.indexOf("\\u", i)) >= 0) {
            if (i + 6 > buf.length()) {
                return buf.toString();
            }
            char[] a = new char[4];
            buf.getChars(i + 2, i + 6, a, 0);
            for (int j = 0; j < 4; ++j) {
                if (a[j] >= '0' && a[j] <= '9' || a[j] >= 'a' && a[j] <= 'f') continue;
                return buf.toString();
            }
            char uni = (char)(QueryListURLReader.hexToByte(a[0]) << 12 | QueryListURLReader.hexToByte(a[1]) << 8 | QueryListURLReader.hexToByte(a[2]) << 4 | QueryListURLReader.hexToByte(a[3]));
            buf.delete(i, i + 6);
            buf.insert(i, uni);
        }
        return buf.toString();
    }

    private static int hexToByte(char c) {
        return c >= 'a' ? 10 + c - 97 : c - 48;
    }
}

