/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2.lsc;

import com.uppaal.model.core2.AbstractTransaction;
import com.uppaal.model.core2.CommandManager;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.lsc.Condition;
import com.uppaal.model.core2.lsc.InstanceLine;

public class AddAnchorCommand
extends AbstractTransaction {
    protected Condition element;
    protected InstanceLine anchor;

    public AddAnchorCommand(CommandManager commandManager, Element element) {
        super(commandManager);
        this.element = (Condition)element;
    }

    public void addAnchor(InstanceLine anchor, int x) {
        if (anchor == null) {
            this.element.setProperty("x", x);
        } else {
            this.anchor = anchor;
        }
        this.element.addAnchor(anchor);
    }

    @Override
    protected void doCancel() {
        this.doUndo();
    }

    @Override
    protected void doExecute() {
        this.addAnchor(this.anchor, 0);
        for (InstanceLine anchor : this.element.getAnchors()) {
            anchor.setProperty("x", anchor.getX());
        }
    }

    @Override
    protected void doUndo() {
        this.element.getAnchors().remove(this.anchor);
        for (InstanceLine anchor : this.element.getAnchors()) {
            anchor.setProperty("x", anchor.getX());
        }
    }

    @Override
    public Element getModifiedElement() {
        return this.element;
    }
}

