/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.engine.QueryResult;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.QueryData;
import com.uppaal.model.core2.QueryListener;
import com.uppaal.model.core2.Visitor;
import java.util.ArrayList;

public class Query
extends Node {
    private static final String PROP_FORMULA = "formula";
    private static final String PROP_COMMENT = "comment";
    private QueryResult result = new QueryResult();
    private final QueryData data = new QueryData();
    private final ArrayList<QueryListener> queryListeners = new ArrayList();

    public Query(String formula, String comment) {
        super(null);
        this.setProperty(PROP_FORMULA, formula);
        this.setProperty(PROP_COMMENT, comment);
    }

    public Query() {
        this("", "");
    }

    public void addQueryListener(QueryListener l) {
        this.queryListeners.add(l);
    }

    public void removeQueryListener(QueryListener l) {
        this.queryListeners.remove(l);
    }

    private void fireQueryChanged(boolean isUndoRedo) {
        Object[] ls;
        for (Object l : ls = this.queryListeners.toArray()) {
            ((QueryListener)l).queryChanged(this, isUndoRedo);
        }
    }

    public String getFormula() {
        return (String)this.getPropertyValue(PROP_FORMULA);
    }

    public String getComment() {
        return (String)this.getPropertyValue(PROP_COMMENT);
    }

    public void setFormula(String formula) {
        this.setProperty(PROP_FORMULA, formula);
        this.fireQueryChanged(false);
    }

    public void setComment(String comment) {
        this.setProperty(PROP_COMMENT, comment);
        this.fireQueryChanged(false);
    }

    public void setFormulaAndComment(String formula, String comment) {
        this.setProperty(PROP_FORMULA, formula);
        this.setProperty(PROP_COMMENT, comment);
        this.fireQueryChanged(true);
    }

    public void setResult(QueryResult r) {
        this.result = r;
    }

    public QueryResult getResult() {
        return this.result;
    }

    public String getShortFormula() {
        String s = this.getFormula();
        StringBuffer out = new StringBuffer();
        int j = 0;
        int k = s.indexOf(10);
        while (k > -1) {
            out.append(s.substring(j, k).trim()).append(' ');
            j = k + 1;
            k = s.indexOf(10, j);
        }
        out.append(s.substring(j).trim());
        return new String(out);
    }

    @Override
    public void accept(Visitor visitor) throws Exception {
        visitor.visitQuery(this);
    }

    public String toString() {
        String res = this.getShortFormula();
        if (res.length() > 60) {
            res = res.substring(0, 60) + '\u2026';
        }
        return res;
    }
}

