/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractTemplate;
import com.uppaal.model.core2.BranchPoint;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Query;
import com.uppaal.model.core2.QueryList;
import com.uppaal.model.core2.Visitor;
import com.uppaal.model.core2.lsc.Condition;
import com.uppaal.model.core2.lsc.Cut;
import com.uppaal.model.core2.lsc.InstanceLine;
import com.uppaal.model.core2.lsc.Message;
import com.uppaal.model.core2.lsc.Prechart;
import com.uppaal.model.core2.lsc.Update;

public class AbstractVisitor
implements Visitor {
    @Override
    public void visitElement(Element element) throws Exception {
        if (element.properties != null) {
            for (Property property : element.properties.values()) {
                property.accept(this);
            }
        }
    }

    @Override
    public void visitNode(Node node) throws Exception {
        this.visitElement(node);
        node = node.first;
        while (node != null) {
            node.accept(this);
            node = node.next;
        }
    }

    @Override
    public void visitProperty(Property property) throws Exception {
        this.visitElement(property);
    }

    @Override
    public void visitDocument(Document document) throws Exception {
        this.visitNode(document);
    }

    @Override
    public void visitTemplate(AbstractTemplate template) throws Exception {
        this.visitNode(template);
    }

    @Override
    public void visitLocation(Location location) throws Exception {
        this.visitNode(location);
    }

    @Override
    public void visitBranchPoint(BranchPoint branchPoint) throws Exception {
        this.visitNode(branchPoint);
    }

    @Override
    public void visitEdge(Edge edge) throws Exception {
        this.visitNode(edge);
    }

    @Override
    public void visitNail(Nail nail) throws Exception {
        this.visitNode(nail);
    }

    @Override
    public void visitInstanceLine(InstanceLine instance) throws Exception {
        this.visitNode(instance);
    }

    @Override
    public void visitPrechart(Prechart prechart) throws Exception {
        this.visitNode(prechart);
    }

    @Override
    public void visitMessage(Message message) throws Exception {
        this.visitNode(message);
    }

    @Override
    public void visitUpdate(Update update) throws Exception {
        this.visitNode(update);
    }

    @Override
    public void visitCondition(Condition condition) throws Exception {
        this.visitNode(condition);
    }

    @Override
    public void visitCut(Cut cut) throws Exception {
        this.visitNode(cut);
    }

    @Override
    public void visitQueries(QueryList queryList) throws Exception {
        for (Query query : queryList) {
            query.accept(this);
        }
    }

    @Override
    public void visitQuery(Query query) throws Exception {
    }
}

