/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.CannotEvaluateException;
import com.uppaal.engine.DotProtocol;
import com.uppaal.engine.EngineException;
import com.uppaal.engine.KeyValueProtocol;
import com.uppaal.engine.Problem;
import com.uppaal.engine.Protocol;
import com.uppaal.engine.ProtocolException;
import com.uppaal.engine.QueryFeedback;
import com.uppaal.engine.QueryResult;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Query;
import com.uppaal.model.lscsystem.LscProcess;
import com.uppaal.model.system.GanttChart;
import com.uppaal.model.system.SystemEdgeSelect;
import com.uppaal.model.system.UppaalSystem;
import com.uppaal.model.system.concrete.ConcreteState;
import com.uppaal.model.system.concrete.ConcreteSuccessor;
import com.uppaal.model.system.symbolic.SymbolicState;
import com.uppaal.model.system.symbolic.SymbolicTransition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.Socket;
import java.util.ArrayList;

public class EngineStub {
    public static int LOCAL = 0;
    public static int SERVER = 1;
    public static int BOTH = 2;
    public static String DEFAULT_HOST = "localhost";
    public static int DEFAULT_PORT = 2350;
    private int serverPort;
    private String serverHost;
    private String serverPath;
    private int connectionMode;
    private int connectedPort;
    private Process process;
    private Socket socket;
    private OutputStream out;
    private InputStream in;
    private String protocolVersion;
    private Protocol protocol;
    private StringBuffer errors;

    public EngineStub() {
        this(LOCAL, DEFAULT_PORT, DEFAULT_HOST, null);
    }

    public EngineStub(int mode, int port, String host, String path) {
        this.connectionMode = mode;
        this.serverPort = port;
        this.serverHost = host;
        this.serverPath = path;
    }

    public String getErrorStream() {
        if (this.errors != null && this.errors.length() > 0) {
            return this.errors.toString();
        }
        return null;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int port) {
        this.serverPort = port;
    }

    public int getConnectionMode() {
        return this.connectionMode;
    }

    public synchronized void setConnectionMode(int mode) {
        this.connectionMode = mode;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public synchronized void setServerHost(String host) {
        this.serverHost = host;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    public int getConnectedPort() {
        return this.connectedPort;
    }

    public synchronized void setServerPath(String path) {
        this.serverPath = path;
    }

    public boolean isConnected() {
        return (this.socket != null || this.process != null) && this.protocol != null;
    }

    public boolean isRemoteConnection() {
        return this.socket != null;
    }

    private void connectLocal() throws EngineException {
        try {
            String[] cmd = new String[]{this.getServerPath()};
            this.process = Runtime.getRuntime().exec(cmd);
            this.out = this.process.getOutputStream();
            this.in = this.process.getInputStream();
            final InputStream err = this.process.getErrorStream();
            if (this.in == null || this.out == null || err == null) {
                int v = this.process.exitValue();
                throw new EngineException("Engine stopped with error code " + v);
            }
            this.errors = new StringBuffer();
            new Thread("ServerErrorStream"){

                @Override
                public void run() {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(err));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            System.err.println(line);
                            EngineStub.this.errors.append(line).append(System.lineSeparator());
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }.start();
        }
        catch (IOException e) {
            throw new EngineException(e.getMessage());
        }
        catch (IllegalThreadStateException e) {
            throw new EngineException("Could not get I/O streams from engine.");
        }
    }

    private void connectRemote() throws EngineException {
        try {
            this.socket = new Socket(this.getServerHost(), this.getServerPort());
            this.connectedPort = this.serverPort;
            this.out = this.socket.getOutputStream();
            this.in = this.socket.getInputStream();
        }
        catch (IOException e) {
            if (this.getConnectionMode() == SERVER) {
                throw new EngineException(e.getMessage());
            }
            this.connectLocal();
        }
    }

    public synchronized void connect() throws EngineException, IOException {
        if (!this.isConnected()) {
            if (this.getConnectionMode() != LOCAL) {
                this.connectRemote();
            } else {
                this.connectLocal();
            }
            this.handshake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() {
        block12: {
            if (!this.isConnected()) {
                return;
            }
            try {
                Object lock;
                if (this.protocol != null) {
                    this.protocol.close();
                }
                this.connectedPort = -1;
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.socket = null;
                }
                if (this.process == null) break block12;
                Object object = lock = new Object();
                synchronized (object) {
                    Thread t = new Thread("EngineWaiter"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                EngineStub.this.process.waitFor();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            Object object = lock;
                            synchronized (object) {
                                lock.notify();
                            }
                        }
                    };
                    t.start();
                    try {
                        lock.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.process.destroy();
                    this.process = null;
                }
            }
            catch (IOException e) {
                this.kill();
            }
        }
    }

    public void kill() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
    }

    public synchronized void handshake() throws IOException, EngineException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
        String line = reader.readLine();
        if (line == null) {
            this.protocol = null;
            if (this.process != null) {
                try {
                    this.process.destroy();
                    int v = this.process.waitFor();
                    throw new EngineException("Server exited with error " + v + ". Check whether OS is supported.");
                }
                catch (InterruptedException interruptedException) {}
            } else {
                throw new EngineException("Server closed connection.");
            }
        }
        switch (line) {
            case "ok": {
                this.protocolVersion = "DotProtocol";
                this.protocol = new DotProtocol(this.in, this.out);
                line = reader.readLine();
                if (line.equals(".")) break;
                throw new ProtocolException("Bug: Dot expected");
            }
            case "protocol Key-Value": {
                this.protocolVersion = "Key-Value";
                this.protocol = new KeyValueProtocol(this.in, this.out);
                line = reader.readLine();
                if (line.equals(".")) break;
                throw new ProtocolException("Bug: Dot expected");
            }
            default: {
                throw new ProtocolException("Unknown protocol version: " + line);
            }
        }
    }

    public synchronized String getVersion() throws IOException, EngineException {
        try {
            return this.protocol.getVersion();
        }
        catch (IOException e) {
            String err = this.getErrorStream();
            if (err != null && err.length() > 0) {
                throw new EngineException(err, e);
            }
            throw e;
        }
    }

    public synchronized String getOptionsInfo() throws EngineException, IOException {
        try {
            return this.protocol.getOptionsInfo();
        }
        catch (IOException e) {
            String err = this.getErrorStream();
            if (err != null && err.length() > 0) {
                throw new EngineException(err, e);
            }
            throw e;
        }
    }

    public synchronized void setOptions(String options) throws EngineException, IOException {
        try {
            this.protocol.setOptions(options);
        }
        catch (IOException e) {
            String err = this.getErrorStream();
            if (err != null && err.length() > 0) {
                throw new EngineException(err, e);
            }
            throw e;
        }
    }

    public synchronized SymbolicState getSymbolicInitial(UppaalSystem system) throws EngineException, IOException, CannotEvaluateException {
        try {
            return this.protocol.getSymbolicInitial(system);
        }
        catch (IOException e) {
            String err = this.getErrorStream();
            if (err != null && err.length() > 0) {
                throw new EngineException(err, e);
            }
            throw e;
        }
    }

    public synchronized ConcreteState getConcreteInitial(UppaalSystem system) throws EngineException, IOException, CannotEvaluateException {
        try {
            return this.protocol.getConcreteInitial(system);
        }
        catch (IOException e) {
            String err = this.getErrorStream();
            if (err != null && err.length() > 0) {
                throw new EngineException(err, e);
            }
            throw e;
        }
    }

    public synchronized ConcreteSuccessor getConcreteSuccessor(UppaalSystem system, ConcreteState state, SystemEdgeSelect[] edges, BigDecimal currentTime, BigDecimal delay) throws EngineException, IOException, CannotEvaluateException {
        try {
            return this.protocol.getConcreteSuccessor(system, state, edges, currentTime, delay);
        }
        catch (IOException e) {
            String err = this.getErrorStream();
            if (err != null && err.length() > 0) {
                throw new EngineException(err, e);
            }
            throw e;
        }
    }

    public synchronized GanttChart getGanttChart(UppaalSystem system, BigDecimal globalTime) throws EngineException, IOException {
        try {
            return this.protocol.getGanttChart(system, globalTime);
        }
        catch (IOException e) {
            String err = this.getErrorStream();
            if (err != null && err.length() > 0) {
                throw new EngineException(err, e);
            }
            throw e;
        }
    }

    public synchronized ArrayList<SymbolicTransition> getTransitions(UppaalSystem system, SymbolicState state) throws EngineException, IOException, CannotEvaluateException {
        try {
            return this.protocol.getTransitions(system, state);
        }
        catch (IOException e) {
            String err = this.getErrorStream();
            if (err != null && err.length() > 0) {
                throw new EngineException(err, e);
            }
            throw e;
        }
    }

    public synchronized UppaalSystem upload(Document document, ArrayList<Problem> problems) throws EngineException, IOException {
        if (this.protocol == null) {
            throw new IOException("Could not connect to server");
        }
        try {
            return this.protocol.upload(document, problems);
        }
        catch (IOException e) {
            String err = this.getErrorStream();
            if (err != null && err.length() > 0) {
                throw new EngineException(err, e);
            }
            throw e;
        }
    }

    public synchronized LscProcess uploadLsc(Document document, ArrayList<Problem> problems) throws EngineException, IOException {
        try {
            return this.protocol.uploadLsc(document, problems);
        }
        catch (IOException e) {
            String err = this.getErrorStream();
            if (err != null && err.length() > 0) {
                throw new EngineException(err, e);
            }
            throw e;
        }
    }

    public synchronized UppaalSystem upload(Document document) throws EngineException, IOException {
        try {
            return this.protocol.upload(document);
        }
        catch (IOException e) {
            String err = this.getErrorStream();
            if (err != null && err.length() > 0) {
                throw new EngineException(err, e);
            }
            throw e;
        }
    }

    public synchronized QueryResult query(UppaalSystem system, Query query, QueryFeedback f) throws EngineException, IOException {
        try {
            return this.protocol.query(system, query, f);
        }
        catch (IOException e) {
            String err = this.getErrorStream();
            if (err != null && err.length() > 0) {
                throw new EngineException(err, e);
            }
            throw e;
        }
    }

    public synchronized QueryResult query(UppaalSystem system, SymbolicState state, Query query, QueryFeedback f) throws EngineException, IOException, CannotEvaluateException {
        return this.protocol.query(system, state, query, f);
    }
}

