/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system.concrete;

import java.math.BigDecimal;

public class Limit
implements Cloneable {
    private BigDecimal value;
    private boolean strict;

    public Limit() {
        this.value = null;
        this.strict = true;
    }

    public Limit(BigDecimal limit, boolean strict) {
        this.value = limit;
        this.strict = strict;
    }

    public String toString() {
        return this.isUnbounded() ? "<inf" : (this.isStrict() ? "<" : "<=") + this.getValue().toString();
    }

    public boolean isUnbounded() {
        return this.value == null;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public double getDoubleValue() {
        return this.value == null ? Double.POSITIVE_INFINITY : this.value.doubleValue();
    }

    public void setValue(BigDecimal limit) {
        this.value = limit;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isUpperBoundOf(BigDecimal arg) {
        return this.value == null || this.value.compareTo(arg) >= 0;
    }

    public boolean isLowerBoundOf(BigDecimal arg) {
        return this.value != null && this.value.compareTo(arg) <= 0;
    }

    public boolean isStrictUpperBoundOf(BigDecimal arg) {
        return this.value == null || this.value.compareTo(arg) > 0;
    }

    public boolean isStrictLowerBoundOf(BigDecimal arg) {
        return this.value != null && this.value.compareTo(arg) < 0;
    }

    public Limit add(BigDecimal arg) {
        if (this.value == null) {
            return this;
        }
        this.value = this.value.add(arg);
        return this;
    }

    public boolean isEqualTo(BigDecimal arg) {
        return this.isLowerBoundOf(arg) && this.isUpperBoundOf(arg);
    }

    public Object clone() throws CloneNotSupportedException {
        Limit theClone = new Limit();
        if (this.value == null) {
            theClone.value = null;
        } else {
            theClone.value = new BigDecimal(0);
            theClone.value = theClone.value.add(this.value);
        }
        theClone.strict = this.strict;
        return theClone;
    }

    public boolean isLowerBoundOf(Limit v) {
        return v.isUnbounded() || this.value.compareTo(v.getValue()) <= 0;
    }

    public boolean isUpperBoundOf(Limit v) {
        return this.isUnbounded() || this.value.compareTo(v.getValue()) >= 0;
    }

    public boolean isStrictLowerBoundOf(Limit v) {
        return !this.isUnbounded() && (v.isUnbounded() || this.value.compareTo(v.getValue()) < 0);
    }

    public boolean isStrictUpperBoundOf(Limit v) {
        return !v.isUnbounded() && (this.isUnbounded() || this.value.compareTo(v.getValue()) > 0);
    }
}

