/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2.lsc;

import com.uppaal.model.core2.AbstractTransaction;
import com.uppaal.model.core2.CommandManager;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.lsc.InstanceLine;
import com.uppaal.model.core2.lsc.LscConstants;
import com.uppaal.model.core2.lsc.Message;

public class ChangeMessageEndCommand
extends AbstractTransaction
implements LscConstants {
    protected InstanceLine oldEnd;
    protected Message element;
    protected InstanceLine newEnd;
    protected boolean changeSource = false;
    protected int oldX;
    protected int newX;
    protected int oldY;
    protected int newY;

    public ChangeMessageEndCommand(CommandManager commandManager, Element element, boolean source) {
        super(commandManager);
        this.element = (Message)element;
        this.changeSource = source;
        this.oldEnd = this.changeSource ? ((Message)element).getSource() : ((Message)element).getTarget();
        this.oldX = element.getX();
        this.oldY = element.getY();
    }

    public void changeEnd(int x) {
        this.setEnd(null);
        this.element.setProperty("x", x);
    }

    public void setFinalEnd(InstanceLine end) {
        this.setEnd(end);
        this.newX = this.element.getX();
        this.newY = this.element.getY();
        this.newEnd = end;
    }

    private void setEnd(InstanceLine end) {
        if (this.changeSource) {
            this.element.setSource(end);
        } else {
            this.element.setTarget(end);
        }
    }

    @Override
    protected void doCancel() {
        this.setEnd(this.oldEnd);
        this.element.setProperty("x", this.oldX);
        this.element.setProperty("y", this.oldY);
        this.element.getTarget().setProperty("x", this.element.getTarget().getX());
        this.element.getSource().setProperty("x", this.element.getSource().getX());
    }

    @Override
    protected void doExecute() {
        this.setEnd(this.newEnd);
        this.element.setProperty("x", this.newX);
        this.element.setProperty("y", this.newY);
        this.element.getTarget().setProperty("x", this.element.getTarget().getX());
        this.element.getSource().setProperty("x", this.element.getSource().getX());
    }

    @Override
    protected void doUndo() {
        this.doCancel();
    }

    @Override
    public Element getModifiedElement() {
        return this.element;
    }
}

