/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractLocation;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.EventListener;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Visitor;

public class Edge
extends Node {
    protected AbstractLocation source;
    protected AbstractLocation target;
    static final String[] xmlLabelKinds = new String[]{"select", "guard", "synchronisation", "assignment", "testcode", "probability", "comments"};

    public Edge(Element prototype) {
        super(prototype);
    }

    public AbstractLocation getSource() {
        return this.source;
    }

    public AbstractLocation getTarget() {
        return this.target;
    }

    public Nail getNails() {
        return (Nail)this.first;
    }

    public void setSource(AbstractLocation source) {
        AbstractLocation old = this.source;
        this.source = source;
        this.fireSourceChanged(old);
    }

    public void setTarget(AbstractLocation target) {
        AbstractLocation old = this.target;
        this.target = target;
        this.fireTargetChanged(old);
    }

    public Nail createNail() {
        return new Nail((Element)this.getPropertyValue("#nail"));
    }

    @Override
    public void accept(Visitor visitor) throws Exception {
        visitor.visitEdge(this);
    }

    void fireSourceChanged(AbstractLocation oldSource) {
        if (this.getDocument() != null) {
            Element element = this;
            do {
                if (element.listeners == null) continue;
                for (EventListener l : element.listeners) {
                    l.edgeSourceChanged(this, oldSource, this.source);
                }
            } while ((element = element.prototype) != null);
        }
    }

    void fireTargetChanged(AbstractLocation oldTarget) {
        if (this.getDocument() != null) {
            Element element = this;
            do {
                if (element.listeners == null) continue;
                for (EventListener l : element.listeners) {
                    l.edgeTargetChanged(this, oldTarget, this.target);
                }
            } while ((element = element.prototype) != null);
        }
    }

    @Override
    public Element getPrototypeFromParent(Element parent) {
        return (Element)parent.getPropertyValue("#edge");
    }

    public String getName() {
        return this.getSource().getName() + "\u2192" + this.getTarget().getName();
    }

    @Override
    public String[] getXMLLabelKinds() {
        return xmlLabelKinds;
    }
}

