/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.CannotEvaluateException;
import com.uppaal.engine.EngineException;
import com.uppaal.engine.EngineStub;
import com.uppaal.engine.Job;
import com.uppaal.engine.Problem;
import com.uppaal.engine.QueryFeedback;
import com.uppaal.engine.QueryResult;
import com.uppaal.gui.Main;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Query;
import com.uppaal.model.lscsystem.LscProcess;
import com.uppaal.model.system.GanttChart;
import com.uppaal.model.system.SystemEdgeSelect;
import com.uppaal.model.system.UppaalSystem;
import com.uppaal.model.system.concrete.ConcreteState;
import com.uppaal.model.system.concrete.ConcreteSuccessor;
import com.uppaal.model.system.symbolic.SymbolicState;
import com.uppaal.model.system.symbolic.SymbolicTransition;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Engine {
    protected EngineStub stub;
    private String version;
    private String options;
    private UppaalSystem system;
    private ExecutorService executor;

    public Engine() {
        this.stub = new EngineStub();
        this.system = null;
        this.executor = Executors.newSingleThreadExecutor();
    }

    public Engine(int mode, int port, String host, String path) {
        this.stub = new EngineStub(mode, port, host, path);
    }

    public void setServerPath(String path) {
        this.disconnect();
        this.stub.setServerPath(path);
    }

    public void setServerPort(int port) {
        this.disconnect();
        this.stub.setServerPort(port);
    }

    public void setServerHost(String host) {
        this.disconnect();
        this.stub.setServerHost(host);
    }

    public void setConnectionMode(int mode) {
        this.disconnect();
        this.stub.setConnectionMode(mode);
    }

    public void disconnect() {
        if (this.stub.isConnected()) {
            this.stub.disconnect();
            this.disconnected();
        }
    }

    public void cancel() {
        if (this.stub.isConnected()) {
            this.stub.kill();
            this.disconnected();
        }
    }

    public synchronized String getVersion() throws EngineException, IOException {
        try {
            this.connect();
            return this.stub.getVersion();
        }
        catch (EngineException | IOException e) {
            this.cancel();
            throw new EngineException(e);
        }
    }

    public synchronized String getOptionsInfo() throws EngineException, IOException {
        try {
            this.connect();
            String it = this.stub.getOptionsInfo();
            return it;
        }
        catch (EngineException | IOException e) {
            this.cancel();
            throw new EngineException(e);
        }
    }

    public synchronized ArrayList<SymbolicTransition> getTransitions(UppaalSystem system, SymbolicState state) throws EngineException, CannotEvaluateException {
        try {
            this.activate(system);
            return this.stub.getTransitions(system, state);
        }
        catch (EngineException | IOException e) {
            this.cancel();
            System.err.println("=============================");
            e.printStackTrace(System.err);
            throw new EngineException(e);
        }
    }

    public synchronized ConcreteSuccessor getConcreteSuccessor(UppaalSystem system, ConcreteState state, SystemEdgeSelect[] edges, BigDecimal currentTime, BigDecimal delay) throws EngineException, CannotEvaluateException {
        try {
            this.activate(system);
            return this.stub.getConcreteSuccessor(system, state, edges, currentTime, delay);
        }
        catch (EngineException | IOException e) {
            this.cancel();
            throw new EngineException(e);
        }
    }

    public synchronized GanttChart getGanttChart(UppaalSystem system, BigDecimal globalTime) throws EngineException {
        try {
            this.activate(system);
            return this.stub.getGanttChart(system, globalTime);
        }
        catch (EngineException | IOException e) {
            this.cancel();
            throw new EngineException(e);
        }
    }

    public synchronized UppaalSystem getSystem(Document document, ArrayList<Problem> problems) throws EngineException {
        try {
            this.connect();
            UppaalSystem s = this.stub.upload(document, problems);
            if (s != null) {
                this.options = null;
                this.version = document.getVersion();
                this.system = s;
            }
            return s;
        }
        catch (EngineException | IOException e) {
            this.cancel();
            throw new EngineException(e);
        }
    }

    public synchronized UppaalSystem getSystem() {
        return this.system;
    }

    public synchronized SymbolicState getInitialState(UppaalSystem system) throws EngineException, CannotEvaluateException {
        try {
            this.activate(system);
            return this.stub.getSymbolicInitial(system);
        }
        catch (EngineException | IOException e) {
            this.cancel();
            throw new EngineException(e);
        }
    }

    public synchronized ConcreteState getConcreteInitialState(UppaalSystem system) throws EngineException, CannotEvaluateException {
        try {
            this.activate(system);
            return this.stub.getConcreteInitial(system);
        }
        catch (EngineException | IOException e) {
            this.cancel();
            throw new EngineException(e);
        }
    }

    public synchronized LscProcess getLscProcess(Document document, ArrayList<Problem> problems) throws EngineException {
        try {
            this.connect();
            LscProcess p = this.stub.uploadLsc(document, problems);
            if (p != null) {
                this.options = null;
                this.version = document.getVersion();
            }
            return p;
        }
        catch (EngineException | IOException e) {
            this.cancel();
            throw new EngineException(e);
        }
    }

    public synchronized QueryResult query(UppaalSystem system, String options, Query query, QueryFeedback f) throws EngineException {
        try {
            this.activate(system);
            if (!options.equals(this.options)) {
                this.stub.setOptions(options);
                this.options = options;
            }
            return this.stub.query(system, query, f);
        }
        catch (EngineException | IOException e) {
            this.cancel();
            e.printStackTrace(System.err);
            throw new EngineException(e);
        }
    }

    public synchronized QueryResult query(UppaalSystem system, SymbolicState state, String options, Query query, QueryFeedback f) throws EngineException, IOException {
        try {
            this.activate(system);
            if (!options.equals(this.options)) {
                this.stub.setOptions(options);
                this.options = options;
            }
            return this.stub.query(system, state, query, f);
        }
        catch (Throwable e) {
            this.cancel();
            e.printStackTrace(System.err);
            throw new EngineException(e);
        }
    }

    private void activate(UppaalSystem value) throws EngineException, IOException {
        this.connect();
        if (Main.LSC || this.system != value || !value.getDocument().getVersion().equals(this.version)) {
            if (this.stub.upload(value.getDocument()) == null) {
                throw new EngineException("Could not transfer model to engine due to syntax errors.");
            }
            this.system = value;
            this.version = value.getDocument().getVersion();
            this.options = null;
        }
    }

    public void connect() throws EngineException, IOException {
        if (!this.stub.isConnected()) {
            this.stub.connect();
            this.version = null;
            this.system = null;
            this.options = null;
            this.connected();
        }
    }

    protected void connected() throws IOException, EngineException {
    }

    protected void disconnected() {
    }

    public void submit(final Job job) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    job.run(Engine.this);
                }
                catch (Throwable ex) {
                    job.error(ex);
                }
            }
        });
    }
}

